*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           OperatingSystem
Library           JSONLibrary
Resource          environment/individualSubscription.txt

*** Test Cases ***
GET Individual Performance Subscription
    [Documentation]    Test ID: 8.3.2.7.1
    ...    Test title: GET Individual Performance Subscription
    ...    Test objective: The objective is to test the retrieval of individual performance subscription and perform a JSON schema validation of the returned subscription data structure.
    ...    Pre-conditions: An instance is instantiated. At least one performance subscription is available in the NFV-MANO.
    ...    Reference: clause 6.5.9.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Performance Subscription
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmSubscription
    Check HTTP Response Body Subscription Identifier matches the requested Subscription

GET Individual Performance Subscription with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.7.2
    ...    Test title: GET Individual Performance Subscription with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual performance subscription fails when using an invalid resource identifier.
    ...    Pre-conditions: An instance is instantiated. At least one performance subscription is available in the NFV-MANO.
    ...    Reference: clause 6.5.9.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual Performance Subscription with invalid resource identifier
    Check HTTP Response Status Code Is    404

DELETE Individual Performance Subscription
    [Documentation]    Test ID: 8.3.2.7.3
    ...    Test title: DELETE Individual Performance Subscription
    ...    Test objective: The objective is to test the deletion of an individual performance subscription
    ...    Pre-conditions: An instance is instantiated. At least one performance subscription is available in the NFV-MANO.
    ...    Reference: clause 6.5.9.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Performance Subscription is not available anymore in the NFV-MANO    
    Send Delete request for individual Performance Subscription
    Check HTTP Response Status Code Is    204
    Check Postcondition Performance Subscription is Deleted

DELETE Individual Performance Subscription with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.7.4
    ...    Test title: DELETE Individual Performance Subscription with invalid resource identifier
    ...    Test objective: The objective is to test that the deletion of an individual performance subscription fails when using an invalid resource identifier.
    ...    Pre-conditions: An instance is instantiated. At least one performance subscription is available in the NFV-MANO.
    ...    Reference: clause 6.5.9.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none   
    Send Delete request for individual Performance Subscription with invalid resource identifier
    Check HTTP Response Status Code Is    404

POST Individual Performance Subscription - Method not implemented
    [Documentation]    Test ID: 8.3.2.7.5
    ...    Test title: POST Individual Performance Subscription - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new Performance Subscription
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.9.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for individual Performance Subscription
    Check HTTP Response Status Code Is    405

PUT Individual Performance Subscription - Method not implemented
    [Documentation]    Test ID: 8.3.2.7.6
    ...    Test title: PUT Individual Performance Subscription - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing Performance subscription.
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.9.3.3 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for individual Performance Threshold
    Check HTTP Response Status Code Is    405

PATCH Individual Performance Subscription - Method not implemented
    [Documentation]    Test ID: 8.3.2.7.7
    ...    Test title: PATCH Individual Performance Subscription - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify an existing Performance subscription
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.9.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for individual Performance Threshold
    Check HTTP Response Status Code Is    405

*** Keywords ***
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK 

Get Individual Performance Subscription
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check HTTP Response Body Subscription Identifier matches the requested Subscription
    Log    Trying to check response ID
    Should Be Equal As Strings   ${response['body']['id']}    ${subscriptionId} 
    Log    Subscription identifier as expected
    
GET individual Performance Subscription with invalid resource identifier
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${erroneousSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Delete request for individual Performance Subscription
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual Performance Subscription with invalid resource identifier
    Log    Trying to delete a subscription in the NFV-MANO with invalid id
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${erroneousSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}
    
Check Postcondition Performance Subscription is Deleted
    Log    Check Postcondition Subscription is deleted
    GET individual Performance Subscription
    Check HTTP Response Status Code Is    404 
    
Send Post request for individual Performance Subscription
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${newSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}
    
Send Put request for individual Performance Threshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}
    
Send Patch request for individual Performance Threshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}