*** Settings ***
Resource   environment/variables.txt
Resource   FaultManagement-APIKeyword.robot  
Library    REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    OperatingSystem

*** Test Cases ***
POST Alarms - Method not implemented
     [Documentation]    Test ID: 8.3.3.1.1
    ...    Test title: POST Alarms - Method not implemented 
    ...    Test objective: The objective is to test that Post method is not allowed to create fault management alarms on NFV-MANO
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.3.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    Send POST request for fault management Alarms
    Check HTTP Response Status Code Is    405

Get information about multiple alarms  
    [Documentation]    Test ID: 8.3.3.1.2
    ...    Test title: Get information about multiple alarms
    ...    Test objective: The objective is to retrieve information about the alarm list and perform a JSON schema of the returned alarms data structure
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Alarms

Get information about multiple alarms with filter 
    [Documentation]    Test ID: 8.3.3.1.3
    ...    Test title: Get information about multiple alarms with filter
    ...    Test objective: The objective is to retrieve information about the alarm list and perform a JSON schema validation of the returned alarms data structure, and verify that the retrieved information matches the issued attribute-based filters 
    ...    Pre-conditions: none 
    ...    Reference: clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms With Filters 
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Alarms

Get information about multiple alarms with invalid attribute-based filtering parameters
    [Documentation]    Test ID: 8.3.3.1.4
    ...    Test title:  Get information about multiple alarms with invalid attribute-based filtering parameters
    ...    Test objective: The objective is to try to retrieve information about the alarm list with invalid filters and perform a JSON schema validation of the returned problem details data structure
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms With Invalid Filters 
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
Get information about multiple alarms as a Paged Response
    [Documentation]    Test ID: 8.3.3.1.5
    ...    Test title: Get information about multiple alarms as a Paged Response
    ...    Test objective: The objective is to retrieve information about the alarm list as a Paged Response.
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains Link
    
Get information about multiple alarms - Bad Request Response too Big
    [Documentation]    Test ID: 8.3.3.1.6
    ...    Test title:  Get information about multiple alarms - Bad Request Response too Big
    ...    Test objective: The objective is to try to retrieve information about the alarm list because response is too big and perform a JSON schema validation of the returned problem details data structure
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET information about alarms with attribute-based filter "id"
    [Documentation]    Test ID: 8.3.3.1.7
    ...    Test title: GET information about alarms with attribute-based filter "id"
    ...    Test objective: The objective is to retrieve information about the alarm list with alarm filter "id"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms with filter "id"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Alarm
    Check PostCondition HTTP Response Body alarms Matches the requested attribute-based filter "id"
    
GET information about multiple alarms with attribute-based filter "managedObjectId"
    [Documentation]    Test ID: 8.3.3.1.8
    ...    Test title: GET information about multiple alarms with attribute-based filter "managedObjectId"
    ...    Test objective: The objective is to retrieve information about the alarm list with attribute filter "managedObjectId"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms with filter "managedObjectId"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Alarms 
    Check PostCondition HTTP Response Body alarms Matches the requested attribute-based filter "managedObjectId"
    
GET information about multiple alarms with attribute-based filter "eventType"
    [Documentation]    Test ID: 8.3.3.1.9
    ...    Test title: GET information about multiple alarms with attribute-based filter "eventType"
    ...    Test objective: The objective is to retrieve information about the alarm list with attribute filter "eventType"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms with filter "eventType"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Alarms
    Check PostCondition HTTP Response Body alarms Matches the requested attribute-based filter "eventType"
    
GET information about multiple alarms with attribute-based filter "perceivedSeverity"
    [Documentation]    Test ID: 8.3.3.1.10
    ...    Test title: GET information about multiple alarms with attribute-based filter "perceivedSeverity"
    ...    Test objective: The objective is to retrieve information about the alarm list with attribute filter "perceivedSeverity"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms with filter "perceivedSeverity"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Alarms 
    Check PostCondition HTTP Response Body alarms Matches the requested attribute-based filter "perceivedSeverity"
    
GET information about multiple alarms with attribute-based filter "probableCause"
    [Documentation]    Test ID: 8.3.3.1.11
    ...    Test title: GET information about multiple alarms with attribute-based filter "probableCause"
    ...    Test objective: The objective is to retrieve information about the alarm list with attribute filter "probableCause"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Alarms with filter "probableCause"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Alarms
    Check PostCondition HTTP Response Body alarms Matches the requested attribute-based filter "probableCause"

Get information about multiple alarms with malformed authorization token
    [Documentation]    Test ID: 8.3.3.1.12
    ...    Test title: Get information about multiple alarms with malformed authorization token
    ...    Test objective: The objective is to test that the retrieval of information about the alarm list fails when using malformed authorization token
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Fault Management Alarms with malformed authorization token
    Check HTTP Response Status Code Is    401

Get information about multiple alarms without authorization token
    [Documentation]    Test ID: 8.3.3.1.13
    ...    Test title: Get information about multiple alarms without authorization token
    ...    Test objective: The objective is to test that the retrieval of information about the alarm list fails when omitting the authorization token
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Fault Management Alarms without authorization token
    Check HTTP Response Status Code Is    401

GET information about multiple alarms with expired or revoked authorization token
    [Documentation]    Test ID: 8.3.3.1.14
    ...    Test title: GET information about multiple alarms with expired or revoked authorization token
    ...    Test objective: The objective is to test that the retrieval of information about the alarm list fails when using expired or revoked authorization token
    ...    Pre-conditions: One or more Network Service Descriptors are onboarded in the NFVO
    ...    Reference: clause 7.5.3.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Fault Management Alarms with expired or revoked authorization token
    Check HTTP Response Status Code Is    401

PUT Alarms - Method not implemented
    [Documentation]    Test ID: 8.3.3.1.15
    ...    Test title: PUT Alarms - Method not implemented 
    ...    Test objective: The objective is to test that PUT method is not allowed to modify fault management alarms on NFV-MANO.
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.3.3.3 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    PUT Fault management Alarms
    Check HTTP Response Status Code Is    405

PATCH Alarms - Method not implemented
     [Documentation]    Test ID: 8.3.3.1.16
    ...    Test title: PATCH Alarms - Method not implemented 
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify fault management alarms on NFV-MANO.
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.3.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    PATCH Fault management Alarms
    Check HTTP Response Status Code Is    405

DELETE Alarms - Method not implemented
     [Documentation]    Test ID: 8.3.3.1.17
    ...    Test title: POST Alarms - Method not implemented 
    ...    Test objective: The objective is to test that DELETE method is not allowed for fault management alarms on NFV-MANO
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.3.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    DELETE Fault management Alarms
    Check HTTP Response Status Code Is    405
    