/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.mockserver.client.netty.proxy.ProxyConfiguration;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.mockserver.MockServerUnificationInitializer;

public class MockServer
extends LifeCycle {
    private InetSocketAddress remoteSocket;

    public MockServer(Integer ... localPorts) {
        this(ProxyConfiguration.proxyConfiguration(), localPorts);
    }

    public MockServer(ProxyConfiguration proxyConfiguration, Integer ... localPorts) {
        this.createServerBootstrap(proxyConfiguration, localPorts);
        this.getLocalPort();
    }

    public MockServer(Integer remotePort, @Nullable String remoteHost, Integer ... localPorts) {
        this(ProxyConfiguration.proxyConfiguration(), remoteHost, remotePort, localPorts);
    }

    public MockServer(ProxyConfiguration proxyConfiguration, @Nullable String remoteHost, Integer remotePort, Integer ... localPorts) {
        if (remotePort == null) {
            throw new IllegalArgumentException("You must specify a remote hostname");
        }
        if (remoteHost == null) {
            remoteHost = "localhost";
        }
        this.remoteSocket = new InetSocketAddress(remoteHost, (int)remotePort);
        this.createServerBootstrap(proxyConfiguration, localPorts);
        this.getLocalPort();
    }

    private void createServerBootstrap(ProxyConfiguration proxyConfiguration, Integer ... localPorts) {
        List<Integer> portBindings = Collections.singletonList(0);
        if (localPorts != null && localPorts.length > 0) {
            portBindings = Arrays.asList(localPorts);
        }
        this.serverServerBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, 1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, true).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).childHandler(new MockServerUnificationInitializer(this, this.httpStateHandler, proxyConfiguration)).childAttr(ActionHandler.REMOTE_SOCKET, this.remoteSocket).childAttr(MockServerHandler.PROXYING, this.remoteSocket != null);
        this.bindServerPorts(portBindings);
        this.startedServer(this.getLocalPorts());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                MockServer.super.stop();
            }
        }));
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }
}

