*** Settings ***
Library    String
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           OperatingSystem
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Package Onboarding Notification
    [Documentation]    Test ID: 7.3.3.12.1
    ...    Test title: VNF Package Onboarding Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Package Onboarding notification.
    ...    Pre-conditions: A VNF package subscription for onboarding notifications is available in the NFVO.
    ...    Reference: Clause 10.4.9.3.1 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Package Onboarding Notification
    Check HTTP Response Status Code Is    204
    
VNF Package Change Notification
    [Documentation]    Test ID: 7.3.3.12.2
    ...    Test title: VNF Package Change Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Package Change notification.
    ...    Pre-conditions: A VNF package subscription for change notifications is available in the NFVO.
    ...    Reference: Clause 10.4.9.3.1 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Package Change Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    PkgmSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Post VNF Package Onboarding Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfPackageOnboardingNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfPackageId=${vnfPackageId}   vndId=${vndId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
Post VNF Package Change Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfPackageChangeNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfPackageId=${vnfPackageId}   vndId=${vndId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}