*** Settings ***
Resource    environment/variables.txt 
Resource    FaultManagement-APIKeyword.robot
Library    DependencyLibrary    
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT} 
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
Create a new Fault Management alarm subscription
    [Documentation]    Test ID:8.3.3.3.1
    ...    Test title: Create a new fault management alarm subscription
    ...    Test objective: The objective is to create a new fault management alarm subscription and perform a JSON schema validation of the returned fault management alarms subscription data structure
    ...    Pre-conditions: No subscription with the same filter and callbackUri exists
    ...    Reference: clause 7.5.5.3.1 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:   Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: subscription is created
    POST Subscription
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is  FmSubscription
    Check HTTP Response Header Contains Location
    Check PostCondition Subscription is created

Create a new alarm subscription - DUPLICATION
     [Documentation]    Test ID: 8.3.3.3.2
    ...    Test title: Create a new alarm subscription - DUPLICATION
    ...    Test objective: The objective is to create a new subscription with the NFV-MANO allowing duplication and perform a JSON schema validation of the returned fault management alarms subscription data structure.
    ...    Pre-conditions: subscription with the same filter and callbackUri exists
    ...    Reference: clause 7.5.5.3.1 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:   Config_prod_NFV-MANO
    ...    Applicability: the NFV-MANO allows creating a subscription resource if another subscription resource with the same filter and callbackUri already exists
    ...    Post-Conditions: duplicated subscription is created
    POST Subscription Duplication permitted
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is  FmSubscription
    Check HTTP Response Header Contains Location
    Check Postcondition FaultManagement Subscription Is Set

Create a new alarm subscription - NO DUPLICATION
    [Documentation]    Test ID: 8.3.3.3.3
    ...    Test title: Create a new alarm subscription - NO DUPLICATION
    ...    Test objective: The objective is to create a new subscription with the NFV-MANO not allowing duplication and perform a JSON schema validation of the returned fault management alarms subscription data structure.
    ...    Pre-conditions: subscription with the same filter and callbackUri exists
    ...    Reference: clause 7.5.5.3.1 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:   Config_prod_NFV-MANO
    ...    Applicability: the NFV-MANO does not allow to create a duplicate subscription resource 
    ...    Post-Conditions: duplicated subscription is not created
    POST Subscription Duplication not permitted
    Check HTTP Response Status Code Is    303
    Check HTTP Response Body Json Schema Is  FmSubscription
    Check HTTP Response Header Contains Location
    Check Postcondition Subscription Resource Returned in Location Header Is Available

Retrieve a list of alarm subscriptions
    [Documentation]    Test ID: 8.3.3.3.4
    ...    Test title: Retrieve a list of alarm subscriptions
    ...    Test objective: The objective is to retrieve the list of active subscriptions and perform a JSON schema validation of the returned fault management alarms subscription data structure.
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:   Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: noe
    GET Subscriptions
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    FmSubscriptions
    
Retrieve a list of alarm subscriptions with filter
    [Documentation]    Test ID: 8.3.3.3.5
    ...    Test title: Retrieve a list of alarm subscriptions with filter
    ...    Test objective: The objective is to retrieve the list of active subscriptions with filter and perform a JSON schema validation of the returned fault management alarms subscription data structure.
    ...    Pre-conditions: none 
    ...    Reference: clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:   Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    GET Subscriptions with filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    FmSubscriptions
    
Get information about multiple alarms as a Paged Response
    [Documentation]    Test ID: 8.3.3.3.6
    ...    Test title: Get information about multiple alarms as a Paged Response
    ...    Test objective: The objective is to retrieve information about active list subscriptions as a Paged Response
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Subscriptions
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains Link
    
GET subscriptions - Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 8.3.3.3.7
    ...    Test title: GET subscriptions - Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to retrieve the list of active subscriptions with Invalid attribute-based filtering parameters and perform a JSON schema validation of the returned problem details data structure.
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:   Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions:    none 
    GET Subscriptions with Invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
Get information about multiple alarms - Bad Request Response too Big
    [Documentation]    Test ID: 8.3.3.3.8
    ...    Test title:  Get information about multiple alarms - Bad Request Response too Big
    ...    Test objective: The objective is to try to retrieve information about active list subscription to check that response is too big and perform a JSON schema validation of the returned problem details data structure
    ...    Pre-conditions: none
    ...    Reference: Clause clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Subscriptions
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET Subscription with attribute-based filter "id"
    [Documentation]    Test ID: 8.3.3.3.9
    ...    Test title: GET Subscription with attribute-based filter "id"
    ...    Test objective: The objective is to retrieve the list of active subscriptions with filter "id"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with filter "id"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   FmSubscription
    Check PostCondition HTTP Response Body Subscription Matches the requested attribute-based filter "id"
    
Get subscriptions with filter "filter.notificationTypes"
    [Documentation]    Test ID: 8.3.3.3.10
    ...    Test title: GET Subscription with attribute-based filter "filter.notificationTypes"
    ...    Test objective: The objective is to retrieve the list of active subscriptions with filter "filter.notificationTypes"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none 
    Get subscriptions with filter "filter_notificationTypes"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   FmSubscriptions 
    Check PostCondition HTTP Response Body Subscriptions Matches the requested attribute-based filter "filter_notificationTypes"
    
Get subscriptions with filter "filter.perceivedSeverities"
    [Documentation]    Test ID: 8.3.3.3.11
    ...    Test title: GET Subscription with attribute-based filter "filter.perceivedSeverities"
    ...    Test objective: The objective is to retrieve the list of active subscriptions with filter "filter.perceivedSeverities"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with filter "filter_perceivedSeverities"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   FmSubscriptions
    Check PostCondition HTTP Response Body Subscriptions Matches the requested attribute-based filter "filter_perceivedSeverities"
    
Get subscriptions with filter "filter.eventTypes"
    [Documentation]    Test ID: 8.3.3.3.12
    ...    Test title: GET Subscription with attribute-based filter "filter.eventTypes"
    ...    Test objective: The objective is to retrieve the list of active subscriptions with filter "filter.eventTypes"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with filter "filter_eventTypes"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   FmSubscriptions
    Check PostCondition HTTP Response Body Subscriptions Matches the requested attribute-based filter "filter_eventTypes"
    
Get subscriptions with filter "filter.probableCauses"
    [Documentation]    Test ID: 8.3.3.3.13
    ...    Test title: GET Subscription with attribute-based filter "filter.probableCauses"
    ...    Test objective: The objective is to retrieve the list of active subscriptions with filter "filter.probableCauses"
    ...    Pre-conditions: none
    ...    Reference: Clause 7.5.5.3.2 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with filter "filter_probableCauses"
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   FmSubscriptions
    Check PostCondition HTTP Response Body Subscriptions Matches the requested attribute-based filter "filter_probableCauses"

PUT subscriptions - Method not implemented
    [Documentation]    Test ID: 8.3.3.3.14
    ...    Test title:PUT subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to for fault management subscriptions on VNF 
    ...    Pre-conditions: none
    ...    RReference: clause 7.5.5.3.3 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:  Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    Put Subscriptions
    Check HTTP Response Status Code Is    405

PATCH subscriptions - Method not implemented
    [Documentation]    Test ID: 8.3.3.3.15
    ...    Test title: PATCH subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to for fault management subscriptions on VNF  
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.5.3.4 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:  Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    PATCH Subscriptions
    Check HTTP Response Status Code Is    405

DELETE subscriptions - Method not implemented
    [Documentation]    Test ID: 8.3.3.3.16
    ...    Test title: DELETE subscriptions - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to for fault management subscriptions on VNF  
    ...    Pre-conditions: none 
    ...    Reference: clause 7.5.5.3.5 - ETSI GS NFV-SOL 009 [6] v3.3.1
    ...    Config ID:  Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Subscriptions
    Check HTTP Response Status Code Is    405