*** Settings ***
Resource    VnfLcmMntOperationKeywords.robot 

*** Test Cases ***
POST VNF State Snapshot - Method not implemented
    [Documentation]    Test ID: 7.3.1.42.1
    ...    Test title: POST VNF State Snapshot - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.1 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST VNF State Snapshot
    Check HTTP Response Status Code Is    405
    
GET VNF State Snapshot - Complete File
    [Documentation]    Test ID: 7.3.1.42.2
    ...    Test title: GET Information about an individual VNF State Snapshot - Complete File
    ...    Test objective: The objective is to fetch the whole content of a VNF State Snapshot using GET method.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.2 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET VNF State Snapshot - Complete
    Check HTTP Response Status Code Is    200
    Check HTTP Content-Type Header Is Set
    
GET VNF State Snapshot - Partial Content
    [Documentation]    Test ID: 7.3.1.42.3
    ...    Test title: GET VNF State Snapshot - Partial Content
    ...    Test objective: The objective is to fetch partial content of a VNF State Snapshot by sending a range request using GET method.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.2 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: VNFM supports range requests
    ...    Post-Conditions: none
    GET VNF State Snapshot - Range Request
    Check HTTP Response Status Code Is    206
    Check HTTP Content-Type Header Is Set
    Check HTTP Content-Range Header Is Set
    
GET VNF State Snapshot - Range Request Not Supported
    [Documentation]    Test ID: 7.3.1.42.4
    ...    Test title: GET VNF State Snapshot - Range Request Not Supported
    ...    Test objective: The objective is to test that the whole content of a VNF State Snapshot is delivered even with a range request when VNFM does not support range requests.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.2 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: VNFM does not support range requests
    ...    Post-Conditions: none
    GET VNF State Snapshot - Range Request
    Check HTTP Response Status Code Is    200
    Check HTTP Content-Type Header Is Set
    Check HTTP Content-Length Header Is Set
    
GET VNF State Snapshot - Range Not Satisfiable
    [Documentation]    Test ID: 7.3.1.42.5
    ...    Test title: GET VNF State Snapshot - Range Not Satisfiable
    ...    Test objective: The objective is to test that an error is returned when the byte range passed in the "Range" header does not match any available byte range in the VNF State Snapshot package file.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.2 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: VNFM supports range requests
    ...    Post-Conditions: none
    GET VNF State Snapshot - Invalid Range
    Check HTTP Response Status Code Is    416

GET VNF State Snapshot - Conflict
    [Documentation]    Test ID: 7.3.1.42.6
    ...    Test title: GET VNF State Snapshot - Conflict
    ...    Test objective: The objective is to test that an error is returned when there is a conflict with the state of the VNF snapshot resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.2 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: Typically, this is due to the fact that the VNF snapshot creation process is not completed.
    ...    Post-Conditions: none
    GET VNF State Snapshot - Conflict in State
    Check HTTP Response Status Code Is    409
    
PUT VNF State Snapshot - Method not implemented 
     [Documentation]    Test ID: 7.3.1.42.7
    ...    Test title: PUT VNF State Snapshot - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.3 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF State Snapshot Package not modified
    PUT VNF State Snapshot
    Check HTTP Response Status Code Is    405

PATCH VNF State Snapshot - Method Not implemented
    [Documentation]    Test ID: 7.3.1.42.8
    ...    Test title: PATCH VNF State Snapshot
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.4 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH VNF State Snapshot
    Check HTTP Response Status Code Is    405

DELETE VNF State Snapshot - Method Not implemented 
    [Documentation]    Test ID: 7.3.1.42.9
    ...    Test title: DELETE VNF State Snapshot - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.25.3.5 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE VNF State Snapshot
    Check HTTP Response Status Code Is    405