# NFV API Conformance Test Specification

This repository hosts the NFV API Conformance test specification for 
the APIs defined in ETSI NFV GS [SOL002](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/002/02.04.01_60/gs_NFV-SOL002v020401p.pdf), [SOL003](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/003/02.04.01_60/gs_NFV-SOL003v020401p.pdf), [SOL005](http://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/005/02.04.01_60/gs_NFV-SOL005v020401p.pdf), in their versions v2.4.1.

## Disclaimer

This repository contains working test cases implemented using the Robot 
framework. It is provided for information only and is still under development. 
The test cases may be updated, deleted, replaced, or obsoleted by other 
contents at any time. As test cases are approved, they will be reflected 
in the normative provisions of 
[GS NFV-TST010](https://docbox.etsi.org/isg/nfv/open/Drafts/TST010_API_Conformance_Testing).

The material in this repository does not guarantee the full compliance 
to the SOL specifications. The normative provisions of the test suite, 
including the scope of the test cases, are still under development. 


## Overview

The Test Specification is built as a collection of [Robot Framework](robotframework.org/) Test Description. [Robot Framework](robotframework.org/) is a generic test automation framework for acceptance testing and acceptance test-driven development.

**IMPORTANT: This repository and the NFV API Conformance Test Specification is Work in Progress. The current version focuses on conformance tests of individual SOL002 and SOL003 resource endpoints. The [Robot Framework](robotframework.org/) Test Descriptions are expected to be consolidated and reviewed in the short term, and possibly re-organized to ease automation of NFV workflows testing. SOL005 Test Descriptions are under development and will be contributed during Q1-2019.**

More information at [NFV API Conformance Test Specification wiki](https://forge.etsi.org/gitlab/nfv/api-tests/wikis/NFV-API-Conformance-Test-Specification).

## How to raise issues

Change requests can be filed at [ETSI Forge Bugzilla](<LINK>). Please report errors, bugs or other issues [here](https://forge.etsi.org/bugzilla/enter_bug.cgi?product=NFV).

## How to contribute

ETSI Forge uses Gitlab to manage submissions to the repository.
For more information on setting up your environment and contributing, you may refer to the [ETSI Forge wiki](https://forge.etsi.org/wiki/index.php/Main_Page).

## License

Copyright (c) ETSI 2018.
 
This software is subject to copyrights owned by ETSI. Non-exclusive permission 
is hereby granted, free of charge, to copy, reproduce and amend this file 
under the following conditions: It is provided "as is", without warranty of any 
kind, expressed or implied. 

ETSI shall never be liable for any claim, damages, or other liability arising 
from its use or inability of use.This permission does not apply to any documentation 
associated with this file for which ETSI keeps all rights reserved. The present 
copyright notice shall be included in all copies of whole or part of this 
file and shall not imply any sub-license right.
