/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.StringReader;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringBuilderWriter;
import org.apache.velocity.util.StringUtils;

public class ASTStringLiteral
extends SimpleNode {
    private boolean interpolate = true;
    private SimpleNode nodeTree = null;
    private String image = "";

    public ASTStringLiteral(int n) {
        super(n);
    }

    public ASTStringLiteral(Parser parser, int n) {
        super(parser, n);
    }

    @Override
    public Object init(InternalContextAdapter internalContextAdapter, Object object) throws TemplateInitException {
        super.init(internalContextAdapter, object);
        this.interpolate = this.rsvc.getBoolean("runtime.interpolate.string.literals", true) && this.getFirstToken().image.startsWith("\"") && (this.getFirstToken().image.indexOf(36) != -1 || this.getFirstToken().image.indexOf(35) != -1);
        String string = this.getFirstToken().image;
        this.image = string.substring(1, string.length() - 1);
        if (string.startsWith("\"")) {
            this.image = ASTStringLiteral.unescape(this.image);
        }
        if (string.charAt(0) == '\"' || string.charAt(0) == '\'') {
            this.image = this.replaceQuotes(this.image, string.charAt(0));
        }
        if (this.interpolate) {
            StringReader stringReader = new StringReader(this.image);
            Template template = null;
            if (internalContextAdapter != null) {
                template = (Template)internalContextAdapter.getCurrentResource();
            }
            if (template == null) {
                template = new Template();
                template.setName("StringLiteral");
            }
            try {
                this.nodeTree = this.rsvc.parse(stringReader, template);
            }
            catch (ParseException parseException) {
                String string2 = "Failed to parse String literal at " + StringUtils.formatFileString(template.getName(), this.getLine(), this.getColumn());
                throw new TemplateInitException(string2, parseException, template.getName(), this.getColumn(), this.getLine());
            }
            this.adjTokenLineNums(this.nodeTree);
            this.nodeTree.init(internalContextAdapter, this.rsvc);
        }
        this.cleanupParserAndTokens();
        return object;
    }

    @Override
    public String literal() {
        return this.image;
    }

    public void adjTokenLineNums(Node node) {
        Token token = node.getFirstToken();
        while (token != null && token != node.getLastToken()) {
            if (token.beginLine == 1) {
                token.beginColumn += this.getColumn();
            }
            if (token.endLine == 1) {
                token.endColumn += this.getColumn();
            }
            token.beginLine += this.getLine() - 1;
            token.endLine += this.getLine() - 1;
            token = token.next;
        }
    }

    private String replaceQuotes(String string, char c) {
        if (c == '\"' && !string.contains("\"") || c == '\'' && !string.contains("'")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            stringBuilder.append(c2);
            if (i + 1 >= n) continue;
            char c3 = string.charAt(i + 1);
            if ((c != '\"' || c3 != '\"' || c2 != '\"') && (c != '\'' || c3 != '\'' || c2 != '\'')) continue;
            ++i;
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string) {
        int n = string.indexOf("\\u");
        if (n < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        do {
            stringBuilder.append(string.substring(n2, n));
            char c = (char)Integer.parseInt(string.substring(n + 2, n + 6), 16);
            stringBuilder.append(c);
        } while ((n = string.indexOf("\\u", n2 = n + 6)) >= 0);
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) {
        return parserVisitor.visit(this, object);
    }

    public boolean isConstant() {
        return !this.interpolate;
    }

    @Override
    public Object value(InternalContextAdapter internalContextAdapter) {
        if (this.interpolate) {
            try {
                StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
                this.nodeTree.render(internalContextAdapter, stringBuilderWriter);
                return ((Object)stringBuilderWriter).toString();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (IOException iOException) {
                String string = "Error in interpolating string literal";
                this.log.error(string, iOException);
                throw new VelocityException(string, iOException);
            }
        }
        return this.image;
    }

    @Override
    public boolean evaluate(InternalContextAdapter internalContextAdapter) {
        String string = (String)this.value(internalContextAdapter);
        return string != null && (!this.rsvc.getBoolean("directive.if.emptycheck", true) || !string.isEmpty());
    }
}

