/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class TimeToLive
extends ObjectWithReflectiveEqualsHashCodeToString {
    private final TimeUnit timeUnit;
    private final Long timeToLive;
    private final boolean unlimited;
    private final Date createdDate;
    private Date endDate;

    private TimeToLive(TimeUnit timeUnit, Long timeToLive, boolean unlimited) {
        this.addFieldsExcludedFromEqualsAndHashCode("createdDate", "endDate");
        this.timeUnit = timeUnit;
        this.timeToLive = timeToLive;
        this.unlimited = unlimited;
        this.createdDate = new Date();
        if (!unlimited) {
            this.endDate = new Date(System.currentTimeMillis() + timeUnit.toMillis(timeToLive));
        }
    }

    public static TimeToLive unlimited() {
        return new TimeToLive(null, null, true);
    }

    public static TimeToLive exactly(TimeUnit timeUnit, Long timeToLive) {
        return new TimeToLive(timeUnit, timeToLive, false);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean stillAlive() {
        if (this.unlimited || this.isAfterNow(this.endDate)) {
            return true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Remaining time is " + (this.endDate.getTime() - this.createdDate.getTime()) + "ms");
        }
        return false;
    }

    private boolean isAfterNow(Date date) {
        return date.getTime() > System.currentTimeMillis();
    }
}

