/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.mockserver.client.serialization.deserializers.body.BodyDTODeserializer;
import org.mockserver.client.serialization.deserializers.body.BodyWithContentTypeDTODeserializer;
import org.mockserver.client.serialization.deserializers.collections.CookiesDeserializer;
import org.mockserver.client.serialization.deserializers.collections.HeadersDeserializer;
import org.mockserver.client.serialization.deserializers.collections.ParametersDeserializer;
import org.mockserver.client.serialization.deserializers.string.NottableStringDeserializer;
import org.mockserver.client.serialization.model.BinaryBodyDTO;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.client.serialization.model.HttpResponseDTO;
import org.mockserver.client.serialization.model.JsonBodyDTO;
import org.mockserver.client.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.client.serialization.model.ParameterBodyDTO;
import org.mockserver.client.serialization.model.RegexBodyDTO;
import org.mockserver.client.serialization.model.StringBodyDTO;
import org.mockserver.client.serialization.model.XPathBodyDTO;
import org.mockserver.client.serialization.model.XmlBodyDTO;
import org.mockserver.client.serialization.model.XmlSchemaBodyDTO;
import org.mockserver.client.serialization.serializers.body.BinaryBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.BinaryBodySerializer;
import org.mockserver.client.serialization.serializers.body.JsonBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.JsonBodySerializer;
import org.mockserver.client.serialization.serializers.body.JsonSchemaBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.JsonSchemaBodySerializer;
import org.mockserver.client.serialization.serializers.body.ParameterBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.ParameterBodySerializer;
import org.mockserver.client.serialization.serializers.body.RegexBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.RegexBodySerializer;
import org.mockserver.client.serialization.serializers.body.StringBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.StringBodySerializer;
import org.mockserver.client.serialization.serializers.body.XPathBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.XPathBodySerializer;
import org.mockserver.client.serialization.serializers.body.XmlBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.XmlBodySerializer;
import org.mockserver.client.serialization.serializers.body.XmlSchemaBodyDTOSerializer;
import org.mockserver.client.serialization.serializers.body.XmlSchemaBodySerializer;
import org.mockserver.client.serialization.serializers.collections.CookiesSerializer;
import org.mockserver.client.serialization.serializers.collections.HeadersSerializer;
import org.mockserver.client.serialization.serializers.collections.ParametersSerializer;
import org.mockserver.client.serialization.serializers.request.HttpRequestDTOSerializer;
import org.mockserver.client.serialization.serializers.request.HttpRequestSerializer;
import org.mockserver.client.serialization.serializers.response.HttpResponseDTOSerializer;
import org.mockserver.client.serialization.serializers.response.HttpResponseSerializer;
import org.mockserver.client.serialization.serializers.string.NottableStringSerializer;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.NottableString;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.Parameters;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;

public class ObjectMapperFactory {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.buildObjectMapper();

    public static ObjectMapper createObjectMapper() {
        return OBJECT_MAPPER;
    }

    private static ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.registerModule(new Module());
        return objectMapper;
    }

    private static class Module
    extends SimpleModule {
        Module() {
            this.addSerializer(HttpRequest.class, new HttpRequestSerializer());
            this.addSerializer(HttpRequestDTO.class, new HttpRequestDTOSerializer());
            this.addDeserializer(BodyDTO.class, new BodyDTODeserializer());
            this.addDeserializer(BodyWithContentTypeDTO.class, new BodyWithContentTypeDTODeserializer());
            this.addSerializer(BinaryBody.class, new BinaryBodySerializer());
            this.addSerializer(BinaryBodyDTO.class, new BinaryBodyDTOSerializer());
            this.addSerializer(JsonBody.class, new JsonBodySerializer());
            this.addSerializer(JsonBodyDTO.class, new JsonBodyDTOSerializer());
            this.addSerializer(JsonSchemaBody.class, new JsonSchemaBodySerializer());
            this.addSerializer(JsonSchemaBodyDTO.class, new JsonSchemaBodyDTOSerializer());
            this.addSerializer(ParameterBody.class, new ParameterBodySerializer());
            this.addSerializer(ParameterBodyDTO.class, new ParameterBodyDTOSerializer());
            this.addSerializer(RegexBody.class, new RegexBodySerializer());
            this.addSerializer(RegexBodyDTO.class, new RegexBodyDTOSerializer());
            this.addSerializer(StringBody.class, new StringBodySerializer());
            this.addSerializer(StringBodyDTO.class, new StringBodyDTOSerializer());
            this.addSerializer(XmlBody.class, new XmlBodySerializer());
            this.addSerializer(XmlBodyDTO.class, new XmlBodyDTOSerializer());
            this.addSerializer(XPathBody.class, new XPathBodySerializer());
            this.addSerializer(XPathBodyDTO.class, new XPathBodyDTOSerializer());
            this.addSerializer(XmlSchemaBody.class, new XmlSchemaBodySerializer());
            this.addSerializer(XmlSchemaBodyDTO.class, new XmlSchemaBodyDTOSerializer());
            this.addSerializer(NottableString.class, new NottableStringSerializer());
            this.addDeserializer(NottableString.class, new NottableStringDeserializer());
            this.addSerializer(HttpResponse.class, new HttpResponseSerializer());
            this.addSerializer(HttpResponseDTO.class, new HttpResponseDTOSerializer());
            this.addDeserializer(Headers.class, new HeadersDeserializer());
            this.addSerializer(Headers.class, new HeadersSerializer());
            this.addDeserializer(Parameters.class, new ParametersDeserializer());
            this.addSerializer(Parameters.class, new ParametersSerializer());
            this.addDeserializer(Cookies.class, new CookiesDeserializer());
            this.addSerializer(Cookies.class, new CookiesSerializer());
        }
    }
}

