*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          NFVMANOLogManagementKeywords.robot
Library           JSONLibrary
Library           OperatingSystem
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false

*** Test Cases ***
POST Individual Logging Job - Method not implemented
    [Documentation]    Test ID: 8.3.4.2.1
    ...    Test title: POST Individual Logging Job - method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create an Indiviual Logging
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.4.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Logging Job is not created on the NFV-MANO
    Send Post request for individual Logging Job
    Check HTTP Response Status Code Is    405
    Check Postcondition Logging Job is not Created

GET individual Logging Job
    [Documentation]    Test ID: 8.3.4.2.2
    ...    Test title: Get individual Logging Job
    ...    Test objective: The objective is to test the retrieval of an individual logging job and perform a JSON schema and content validation of the collected job data structure
    ...    Pre-conditions: Logging Job is already created.
    ...    Reference: clause 8.5.4.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual Logging Job
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   LoggingJob
    Check HTTP Response Body Logging Job Identifier matches the requested Logging Job

GET individual Logging Job with invalid resource identifier
    [Documentation]    Test ID: 8.3.4.2.3
    ...    Test title: Get individual Logging Job with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual logging job fails when using an invalid resource identifier, and perform the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: Logging Job is already created.
    ...    Reference: clause 8.5.4.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual Logging Job with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Individual Logging Job - Method not implemented
    [Documentation]    Test ID: 8.3.4.2.4
    ...    Test title: PUT Individual Logging Job - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing Logging Job
    ...    Pre-conditions: Logging Job is already created.
    ...    Reference: clause 8.5.4.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Logging Job is not modified by the operation
    Send Put request for individual Logging Job
    Check HTTP Response Status Code Is    405

PATCH Individual Logging Job - Method not implemented
    [Documentation]    Test ID: 8.3.4.2.5
    ...    Test title: PATCH Individual Logging Job - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify an existing new Logging Job
    ...    Pre-conditions: Logging Job is already created.
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Logging Job is not modified by the operation
    Send Patch request for individual Logging Job
    Check HTTP Response Status Code Is    405

DELETE Individual Logging Job
    [Documentation]    Test ID: 8.3.4.2.6
    ...    Test title: DELETE Individual Logging Job
    ...    Test objective: The objective is to test the deletion of an individual logging job
    ...    Pre-conditions: Logging Job is already created.
    ...    Reference: clause 8.5.4.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Logging Job is no more available.   
    Send Delete request for individual Logging Job
    Check HTTP Response Status Code Is    204
    Check Postcondition Logging Job is Deleted

DELETE Individual Logging Job with invalid resource identifier
    [Documentation]    Test ID: 8.3.4.2.7
    ...    Test title: DELETE Individual Logging Job with invalid resource identifier
    ...    Test objective: The objective is to test that the deletion of an individual logging job fails when using an invalid resource identifier
    ...    Pre-conditions: Logging Job is already created.
    ...    Reference: clause 8.5.4.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for individual Logging Job with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails
