*** Settings ***
Resource    environment/variables.txt
Resource    VnfLcmMntOperationKeywords.robot
Resource    SubscriptionKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}        ssl_verify=false
Library    OperatingSystem
Library    BuiltIn
Library    Collections
Library    JSONLibrary
Library    Process

*** Test Cases ***
Terminate a VNF Instance
    [Documentation]    Test ID: 7.3.1.33.1
    ...    Test title: Terminate a VNF Instance
    ...    Test objective: The objective is to terminate a VNF instance.
    ...    Pre-conditions: VNF instance in INSTANTIATED state 
    ...    Reference: Clause 5.3.3 - ETSI GS NFV-SOL 003 [1] v3.5.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: NFVO is able to receive notifications from VNFM. 
    ...    Post-Conditions: VNF instance in NOT_INSTANTIATED state 
    Send Terminate VNF Request
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location 
    Check Operation Occurrence Id existence
    Check Operation Notification For Terminate    STARTING
    Check Operation Notification For Terminate    PROCESSING
    Check Operation Notification For Terminate    COMPLETED
    Check Postcondition VNF Terminate

*** Keywords ***
Check Postcondition VNF Terminate
    Check resource not Instantiated
    
Check Operation Notification For Terminate 
    [Arguments]    ${status}
    Check Operation Notification    VnfLcmOperationOccurrenceNotification   ${status}