*** Settings ***
Resource    environment/configuration.txt
Resource    environment/variables.txt
Resource    environment/scaleVariables.txt
Resource    VnfLcmMntOperationKeywords.robot
Resource    SubscriptionKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    
...    spec=SOL003-VNFLifecycleManagement-API.yaml
Library    OperatingSystem
Library    BuiltIn
Library    Collections
Library    JSONLibrary
Library    Process
Suite Setup    Initialize System
Suite Teardown    Terminate All Processes    kill=true


*** Test Cases ***
VNF Instance Scale To Level
   [Documentation]    Test ID: 5.4.6.1
    ...    Test title: VNF Instance Scale To Level worflow
    ...    Test objective: The objective is to test the workflow for the scale to level of a VNF instance
    ...    Pre-conditions: VNF instance in INSTANTIATED state (Test ID: 5.4.4.1). NFVO is subscribed to VNF LCM Operation Occurrence notifications (Test ID: 5.4.20.1)
    ...    Reference: section 5.4.6 - SOL003 v2.4.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability:  NFVO is able to receive notifications from VNFM. Scale operation is supported for the VNF (as capability in the VNFD)
    ...    Post-Conditions: VNF instance still in INSTANTIATED state and VNF is scaled to the new level
    Send VNF Scale To Level Request
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location 
    Check Operation Occurrence Id
    Check Operation Notification For Scale   STARTING
    Check Operation Notification For Scale    PROCESSING
    Check Operation Notification For Scale    COMPLETED
    Check Postcondition VNF Scaled To New Level  

#Create a new Grant - Sync - Scale REMOVED

*** Keywords ***

Initialize System
    Create Sessions
    ${body}=    Get File    json/scaleVnfToLevelRequest.json
    ${scaleVnfToLevelRequest}=    evaluate    json.loads('''${body}''')    json
    ${instantiationLevelId}=    Get Value From Json    ${scaleVnfToLevelRequest}    $..instantiationLevelId    #How to use this info to get the instantiation scale level?
    ${scaleInfo}=    Get Value From Json    ${scaleVnfToLevelRequest}    $..scaleInfo

Check Postcondition VNF Scaled To New Level
    Check resource instantiated
    ${newScaleInfo}=    Get Vnf Scale Info    ${vnfInstanceId}
    Compare ScaleInfos    ${scaleInfo}    ${newScaleInfo}  
    
Compare ScaleInfos
    [Arguments]    ${old_scaleinfo}    ${new_scaleinfo}
    FOR    ${element}    IN    ${old_scaleinfo}
        ${old_level}=    Set Variable If    ${element.aspectId}==${aspectId}   ${element.scaleLevel}
        ${old_level_value}=    Convert To Integer    ${old_level}
    END
    FOR    ${element}    IN    ${new_scaleinfo}
        ${new_level}=    Set Variable If    ${element.aspectId}==${aspectId}   ${element.scaleLevel}
        ${new_level_value}=    Convert To Integer    ${new_level}
    END
    Should be true    ${old_level_value}==${new_level_value}
    
   
Create a new Grant - Sync - ScaleToLevel
    Create a new Grant - Synchronous mode        ${vnfInstanceId}    ${vnfLcmOpOccId}    SCALE_TO_LEVEL
    
Check Operation Notification For Scale
    [Arguments]    ${status}
    Check Operation Notification    VnfLcmOperationOccurrenceNotification   ${status}
    