/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.netty.SocketCommunicationException;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.client.netty.proxy.ProxyConfiguration;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.log.model.ExpectationMatchLogEntry;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.log.model.RequestLogEntry;
import org.mockserver.log.model.RequestResponseLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.HttpErrorActionHandler;
import org.mockserver.mock.action.HttpForwardActionHandler;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.mock.action.HttpForwardClassCallbackActionHandler;
import org.mockserver.mock.action.HttpForwardObjectCallbackActionHandler;
import org.mockserver.mock.action.HttpForwardTemplateActionHandler;
import org.mockserver.mock.action.HttpOverrideForwardedRequestActionHandler;
import org.mockserver.mock.action.HttpResponseActionHandler;
import org.mockserver.mock.action.HttpResponseClassCallbackActionHandler;
import org.mockserver.mock.action.HttpResponseObjectCallbackActionHandler;
import org.mockserver.mock.action.HttpResponseTemplateActionHandler;
import org.mockserver.model.Action;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.curl.HttpRequestToCurlSerializer;

public class ActionHandler {
    public static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf("REMOTE_SOCKET");
    private final HttpStateHandler httpStateHandler;
    private final Scheduler scheduler;
    private MockServerLogger mockServerLogger;
    private HttpResponseActionHandler httpResponseActionHandler;
    private HttpResponseTemplateActionHandler httpResponseTemplateActionHandler;
    private HttpResponseClassCallbackActionHandler httpResponseClassCallbackActionHandler;
    private HttpResponseObjectCallbackActionHandler httpResponseObjectCallbackActionHandler;
    private HttpForwardActionHandler httpForwardActionHandler;
    private HttpForwardTemplateActionHandler httpForwardTemplateActionHandler;
    private HttpForwardClassCallbackActionHandler httpForwardClassCallbackActionHandler;
    private HttpForwardObjectCallbackActionHandler httpForwardObjectCallbackActionHandler;
    private HttpOverrideForwardedRequestActionHandler httpOverrideForwardedRequestCallbackActionHandler;
    private HttpErrorActionHandler httpErrorActionHandler;
    private NettyHttpClient httpClient;
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();
    private HttpRequestToCurlSerializer httpRequestToCurlSerializer = new HttpRequestToCurlSerializer();

    public ActionHandler(HttpStateHandler httpStateHandler, ProxyConfiguration proxyConfiguration) {
        this.httpStateHandler = httpStateHandler;
        this.scheduler = httpStateHandler.getScheduler();
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.httpClient = new NettyHttpClient(proxyConfiguration);
        this.httpResponseActionHandler = new HttpResponseActionHandler();
        this.httpResponseTemplateActionHandler = new HttpResponseTemplateActionHandler(this.mockServerLogger);
        this.httpResponseClassCallbackActionHandler = new HttpResponseClassCallbackActionHandler(this.mockServerLogger);
        this.httpResponseObjectCallbackActionHandler = new HttpResponseObjectCallbackActionHandler(httpStateHandler);
        this.httpForwardActionHandler = new HttpForwardActionHandler(this.mockServerLogger, this.httpClient);
        this.httpForwardTemplateActionHandler = new HttpForwardTemplateActionHandler(this.mockServerLogger, this.httpClient);
        this.httpForwardClassCallbackActionHandler = new HttpForwardClassCallbackActionHandler(this.mockServerLogger, this.httpClient);
        this.httpForwardObjectCallbackActionHandler = new HttpForwardObjectCallbackActionHandler(httpStateHandler, this.httpClient);
        this.httpOverrideForwardedRequestCallbackActionHandler = new HttpOverrideForwardedRequestActionHandler(this.mockServerLogger, this.httpClient);
        this.httpErrorActionHandler = new HttpErrorActionHandler();
    }

    public void processAction(final HttpRequest request, final ResponseWriter responseWriter, final ChannelHandlerContext ctx, Set<String> localAddresses, boolean proxyThisRequest, final boolean synchronous) {
        Expectation expectation = this.httpStateHandler.firstMatchingExpectation(request);
        if (request.getHeaders().containsEntry("x-forwarded-by", "MockServer")) {
            this.mockServerLogger.trace("Received \"x-forwarded-by\" header caused by exploratory HTTP proxy - falling back to no proxy: {}", request);
            this.returnNotFound(responseWriter, request);
        } else if (expectation != null && expectation.getAction() != null) {
            final Action action = expectation.getAction();
            this.httpStateHandler.log(new ExpectationMatchLogEntry(request, expectation));
            switch (action.getType()) {
                case RESPONSE: {
                    this.scheduler.submit(new Runnable(){

                        @Override
                        public void run() {
                            HttpResponse response = ActionHandler.this.httpResponseActionHandler.handle((HttpResponse)action);
                            ActionHandler.this.writeResponseActionResponse(response, responseWriter, request, action, synchronous);
                        }
                    }, synchronous);
                    break;
                }
                case RESPONSE_TEMPLATE: {
                    this.scheduler.submit(new Runnable(){

                        @Override
                        public void run() {
                            HttpResponse response = ActionHandler.this.httpResponseTemplateActionHandler.handle((HttpTemplate)action, request);
                            ActionHandler.this.writeResponseActionResponse(response, responseWriter, request, action, synchronous);
                        }
                    }, synchronous);
                    break;
                }
                case RESPONSE_CLASS_CALLBACK: {
                    this.scheduler.submit(new Runnable(){

                        @Override
                        public void run() {
                            HttpResponse response = ActionHandler.this.httpResponseClassCallbackActionHandler.handle((HttpClassCallback)action, request);
                            ActionHandler.this.writeResponseActionResponse(response, responseWriter, request, action, synchronous);
                        }
                    }, synchronous);
                    break;
                }
                case RESPONSE_OBJECT_CALLBACK: {
                    this.scheduler.submit(new Runnable(){

                        @Override
                        public void run() {
                            ActionHandler.this.httpResponseObjectCallbackActionHandler.handle(ActionHandler.this, (HttpObjectCallback)action, request, responseWriter, synchronous);
                        }
                    }, synchronous);
                    break;
                }
                case FORWARD: {
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            HttpForwardActionResult responseFuture = ActionHandler.this.httpForwardActionHandler.handle((HttpForward)action, request);
                            ActionHandler.this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        }
                    }, synchronous, action.getDelay());
                    break;
                }
                case FORWARD_TEMPLATE: {
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            HttpForwardActionResult responseFuture = ActionHandler.this.httpForwardTemplateActionHandler.handle((HttpTemplate)action, request);
                            ActionHandler.this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        }
                    }, synchronous, action.getDelay());
                    break;
                }
                case FORWARD_CLASS_CALLBACK: {
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            HttpForwardActionResult responseFuture = ActionHandler.this.httpForwardClassCallbackActionHandler.handle((HttpClassCallback)action, request);
                            ActionHandler.this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        }
                    }, synchronous, action.getDelay());
                    break;
                }
                case FORWARD_OBJECT_CALLBACK: {
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            ActionHandler.this.httpForwardObjectCallbackActionHandler.handle(ActionHandler.this, (HttpObjectCallback)action, request, responseWriter, synchronous);
                        }
                    }, synchronous, action.getDelay());
                    break;
                }
                case FORWARD_REPLACE: {
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            HttpForwardActionResult responseFuture = ActionHandler.this.httpOverrideForwardedRequestCallbackActionHandler.handle((HttpOverrideForwardedRequest)action, request);
                            ActionHandler.this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        }
                    }, synchronous, action.getDelay());
                    break;
                }
                case ERROR: {
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            ActionHandler.this.httpErrorActionHandler.handle((HttpError)action, ctx);
                            ActionHandler.this.mockServerLogger.info(MessageLogEntry.LogMessageType.EXPECTATION_RESPONSE, request, "returning error:{}for request:{}for action:{}", action, request, action);
                        }
                    }, synchronous, action.getDelay());
                }
            }
        } else if ((ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses()) && CORSHeaders.isPreflightRequest(request)) {
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
        } else if (proxyThisRequest || !StringUtils.isEmpty(request.getFirstHeader(HttpHeaderNames.HOST.toString())) && !localAddresses.contains(request.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            final boolean exploratoryHttpProxy = !proxyThisRequest;
            final InetSocketAddress remoteAddress = ctx != null ? ctx.channel().attr(REMOTE_SOCKET).get() : null;
            HttpRequest clonedRequest = this.hopByHopHeaderFilter.onRequest(request);
            if (exploratoryHttpProxy) {
                clonedRequest.withHeader("x-forwarded-by", "MockServer");
            }
            final HttpForwardActionResult responseFuture = new HttpForwardActionResult(clonedRequest, this.httpClient.sendRequest(clonedRequest, remoteAddress, exploratoryHttpProxy ? 1000 : ConfigurationProperties.socketConnectionTimeout()));
            this.scheduler.submit(responseFuture, new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpResponse response = (HttpResponse)responseFuture.getHttpResponse().get();
                        if (response == null) {
                            response = HttpResponse.notFoundResponse();
                        }
                        responseWriter.writeResponse(request, response, false);
                        if (response.containsHeader("x-forwarded-by", "MockServer")) {
                            ActionHandler.this.httpStateHandler.log(new RequestLogEntry(request));
                            ActionHandler.this.mockServerLogger.info(MessageLogEntry.LogMessageType.EXPECTATION_NOT_MATCHED, request, "no expectation for:{}returning response:{}", request, HttpResponse.notFoundResponse());
                        } else {
                            ActionHandler.this.httpStateHandler.log(new RequestResponseLogEntry(request, response));
                            ActionHandler.this.mockServerLogger.info(MessageLogEntry.LogMessageType.FORWARDED_REQUEST, request, "returning response:{}for forwarded request" + Character.NEW_LINE + Character.NEW_LINE + " in json:{}" + Character.NEW_LINE + Character.NEW_LINE + " in curl:{}", response, request, ActionHandler.this.httpRequestToCurlSerializer.toCurl(request, remoteAddress));
                        }
                    }
                    catch (SocketCommunicationException sce) {
                        ActionHandler.this.returnNotFound(responseWriter, request);
                    }
                    catch (Exception ex) {
                        if (exploratoryHttpProxy && (ex.getCause() instanceof ConnectException || ex.getCause() instanceof SocketConnectionException)) {
                            ActionHandler.this.mockServerLogger.trace("Failed to connect to proxied socket due to exploratory HTTP proxy for: {}falling back to no proxy: {}", request, ex.getCause());
                            ActionHandler.this.returnNotFound(responseWriter, request);
                        }
                        ActionHandler.this.mockServerLogger.error(request, (Throwable)ex, ex.getMessage(), new Object[0]);
                    }
                }
            }, synchronous);
        } else {
            this.returnNotFound(responseWriter, request);
        }
    }

    void writeResponseActionResponse(final HttpResponse response, final ResponseWriter responseWriter, final HttpRequest request, final Action action, boolean synchronous) {
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                responseWriter.writeResponse(request, response, false);
                ActionHandler.this.mockServerLogger.info(MessageLogEntry.LogMessageType.EXPECTATION_RESPONSE, request, "returning response:{}for request:{}for action:{}", response, request, action);
            }
        }, synchronous, action.getDelay(), response.getDelay());
    }

    void writeForwardActionResponse(final HttpForwardActionResult responseFuture, final ResponseWriter responseWriter, final HttpRequest request, final Action action, boolean synchronous) {
        this.scheduler.submit(responseFuture, new Runnable(){

            @Override
            public void run() {
                try {
                    HttpResponse response = (HttpResponse)responseFuture.getHttpResponse().get();
                    responseWriter.writeResponse(request, response, false);
                    ActionHandler.this.httpStateHandler.log(new RequestResponseLogEntry(request, response));
                    ActionHandler.this.mockServerLogger.info(MessageLogEntry.LogMessageType.FORWARDED_REQUEST, request, "returning response:{}for forwarded request\n\n in json:{}\n\n in curl:{}for action:{}", response, responseFuture.getHttpRequest(), ActionHandler.this.httpRequestToCurlSerializer.toCurl(responseFuture.getHttpRequest()), action);
                }
                catch (Exception ex) {
                    ActionHandler.this.mockServerLogger.error(request, (Throwable)ex, ex.getMessage(), new Object[0]);
                }
            }
        }, synchronous);
    }

    private void returnNotFound(ResponseWriter responseWriter, HttpRequest request) {
        HttpResponse response = HttpResponse.notFoundResponse();
        if (request.getHeaders().containsEntry("x-forwarded-by", "MockServer")) {
            response.withHeader("x-forwarded-by", "MockServer");
        } else {
            this.httpStateHandler.log(new RequestLogEntry(request));
            this.mockServerLogger.info(MessageLogEntry.LogMessageType.EXPECTATION_NOT_MATCHED, request, "no expectation for:{}returning response:{}", request, HttpResponse.notFoundResponse());
        }
        responseWriter.writeResponse(request, response, false);
    }
}

