*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          environment/individualThresholds.txt
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           OperatingSystem
Library           JSONLibrary
Library           String
Suite Setup    Check resource existence and get CallbackUri


*** Test Cases ***   
Performance Information Available Notification
    [Documentation]    Test ID: 8.3.2.10.1
    ...    Test title: Performance Information Available Notification
    ...    Test objective: The objective is to test that Performance Available Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A subscription for performance available notification is available in the NFV-MANO.
    ...    Reference: clause 6.5.10.3.1 - ETSI GS NFV-SOL 009 [6] V3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Performance Information Available Notification
    Check HTTP Response Status Code Is    204
    
Threshold Crossed Notification
    [Documentation]    Test ID: 8.3.2.10.2
    ...    Test title: Threshold Crossed Notification
    ...    Test objective: The objective is to test that Threshold Crossed Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A subscription for threshold crosssed notification is available in the NFV-MANO.
    ...    Reference: clause 6.5.10.3.1 - ETSI GS NFV-SOL 009 [6] V3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Threshold Crossed Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    PmSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
POST Performance Information Available Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/PerformanceInformationAvailabilityNotification.json
    ${body}=    Format String    ${template}    subscriptionId=${subscriptionId}    objectInstanceId=${objectInstanceIds}    
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST Threshold Crossed Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/ThresholdCrossedNotification.json
    ${body}=    Format String    ${template}    subscriptionId=${subscriptionId}    thresholdId=${thresholdId}    objectInstanceId=${objectInstanceIds}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

    
    


    
    
