*** Settings ***
Library    String
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF LCM Operation Occurrence Notification
    [Documentation]    Test ID: 6.3.5.21.1
    ...    Test title: VNF LCM Operation Occurrence Start Notification
    ...    Test objective:  The objective is to test that VNF LCM Operation Occurrence Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A subscription for VNF LCM Operation Occurrence notifications is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF LCM Operation Occurrence Notification
    Check HTTP Response Status Code Is    204

VNF Identifier Creation Notification
    [Documentation]    Test ID: 6.3.5.21.2
    ...    Test title: VNF Identifier Creation Notification
    ...    Test objective:  The objective is to test that VNF Identifier Creation Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A subscription for VNF Identifier Creation Notification is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Identifier Creation Notification
    Check HTTP Response Status Code Is    204
    
VNF Identifier Deletion Notification
    [Documentation]    Test ID: 6.3.5.21.3
    ...    Test title: VNF Identifier Deletion Notification
    ...    Test objective:  The objective is to test that VNF Identifier Deletion Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A subscription for VNF Identifier Deletion Notification is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Identifier Deletion Notification
    Check HTTP Response Status Code Is    204

*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    Subscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri
    
Post VNF LCM Operation Occurrence Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfLcmOperationOccurrenceNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfInstanceId=${vnfInstanceId}    vnfLcmOpOccId=${vnfLcmOpOccId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
Post VNF Identifier Creation Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfIdentifierCreationNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfInstanceId=${vnfInstanceId}  
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
Post VNF Identifier Deletion Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfIdentifierDeletionNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfInstanceId=${vnfInstanceId}  
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	