*** Settings ***
Resource    environment/variables.txt
Library    REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library    MockServerLibrary 
Library    OperatingSystem
Library    BuiltIn
Library    JSONLibrary
Library    Collections
Library    JSONSchemaLibrary    schemas/
Library    Process

*** Keywords ***
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
Check Operation Occurrence Id
    ${OpOccId}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${OpOccId}

Send Post request for NFV-MANO Entity
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFV-MANO entity resource
    Log    Trying to get a NFV-MANO entity resource 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Put request for NFV-MANO Entity  
    Log    Trying to perform a PUT (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/mano_entity
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/mano_entity
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Patch request for NFV-MANO Entity
    log    Trying to modify an NFV-MANO Entity
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${body}=    Get File    jsons/ManoConfigModificationRequest.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity   ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse} 
	
Send Delete request for NFV-MANO Entity
    Log    Trying to perform a DELETE (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Post request for NFV-MANO functional entity application state change
    Log    Trying to perform a POST for NFV-MANO functional entity application state change
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Get request for NFV-MANO functional entity application state change
    Log    Trying to perform a GET (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Put request for NFV-MANO functional entity application state change
    Log    Trying to perform a PUT (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/mano_entity/change_state
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for NFV-MANO functional entity application state change
    Log    Trying to perform a PATCH (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for NFV-MANO functional entity application state change
    Log    Trying to perform a DELETE (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/mano_entity/change_state
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}