*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF LCM Operation Occurrence Notification
    [Documentation]    Test ID: 6.3.5.20.1
    ...    Test title: VNF LCM Operation Occurrence Start Notification
    ...    Test objective:  The objective is to test that the POST request triggers VNF LCM Operation Occurrence Start Notification
    ...    Pre-conditions: A subscription for VNF LCM Operation Occurrence notifications is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF LCM Operation Occurrence Notification
    Check HTTP Response Status Code Is    204

VNF Identifier Creation Notification
    [Documentation]    Test ID: 6.3.5.20.2
    ...    Test title: VNF Identifier Creation Notification
    ...    Test objective:  The objective is to test that the POST request triggers VNF Identifier Creation Notification
    ...    Pre-conditions: A subscription for VNF Identifier Creation Notification is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Identifier Creation Notification
    Check HTTP Response Status Code Is    204
    
VNF Identifier Deletion Notification
    [Documentation]    Test ID: 6.3.5.20.3
    ...    Test title: VNF Identifier Deletion Notification
    ...    Test objective:  The objective is to test that the POST request triggers VNF Identifier Deletion Notification
    ...    Pre-conditions: A subscription for VNF Identifier Deletion Notification is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Identifier Deletion Notification
    Check HTTP Response Status Code Is    204

*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    subscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri