*** Settings ***
Library    String
Library    JSONSchemaLibrary    schemas/
Resource   environment/variables.txt
Library    OperatingSystem
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Indicator Value Change Notification
    [Documentation]    Test ID: 7.3.6.8.1
    ...    Test title: VNF Indicator Value Change Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Indicator Value Change Notification.
    ...    Pre-conditions: A VNF is instantiated, and a subscription for indicator value change notifications is available in the VNFM.
    ...    Reference: Clause 8.4.7.3.1 - ETSI GS NFV-SOL 003 [1] v2.8.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Indicator Value Change Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    VnfIndicatorSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Post VNF Indicator Value Change Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfIndicatorValueChangeNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    indicatorId=${indicatorId}    vnfInstanceId=${vnfInstanceId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
