*** Settings ***
Resource    VnfLcmMntOperationKeywords.robot
Resource    environment/variables.txt 
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Suite Setup    Check resource existence

*** Test Cases ***
POST Create VNF Snapshot Task 
    [Documentation]    Test ID: 7.3.1.38.1
    ...    Test title: POST Create VNF Snapshot Task
    ...    Test objective: The objective is to test that POST method requests taking a snapshot of a VNF instance.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: in response header Location shall not be null         
    POST Create VNF Snapshot Task
    Check HTTP Response Status Code Is    202
    Check HTTP Location Header Contains URI of Created Resource

POST Create VNF Snapshot Task - NOT FOUND
    [Documentation]    Test ID: 7.3.1.38.2
    ...    Test title: POST Create VNF Snapshot Task - NOT FOUND
    ...    Test objective: The objective is to test that the POST method cannot request for a snapshot if the task is not supported for the VNF instance represented by the parent resource. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: Task is not supported for the VNF instance represented by the parent resource.
    ...    Post-Conditions: none
    POST Create VNF Snapshot Task NOT SUPPORTED
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Create VNF Snapshot Task - CONFLICT
    [Documentation]    Test ID: 7.3.1.38.3
    ...    Test title: POST Create VNF Snapshot Task - CONFLICT
    ...    Test objective: The objective is to test that the POST method cannot request for a snapshot when the VNF instance is in NOT_INSTANTIATED state. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: VNF instance is in NOT_INSTANTIATED state.
    ...    Post-Conditions: none
    POST Create VNF Snapshot Task VNF_NOT_INSTANTIATED
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Create VNF Snapshot Task - UNPROCESSIBLE ENTITY
    [Documentation]    Test ID: 7.3.1.38.4
    ...    Test title: POST Create VNF Snapshot Task - UNPROCESSIBLE ENTITY
    ...    Test objective: The objective is to test that the POST method cannot request for a snapshot when the provided identifier of the target "Individual VNF snapshot" resource for the VNF snapshot is invalid. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: The identifier of the target "Individual VNF snapshot" resource for the VNF snapshot is invalid.
    ...    Post-Conditions: none
    POST Create VNF Snapshot Task INVALID IDENTIFIER
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 
    
GET Create VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 7.3.1.38.5
    ...    Test title: GET Create VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that GET method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET Create VNF Snapshot Task
    Check HTTP Response Status Code Is    405

PUT Create VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 7.3.1.38.6
    ...    Test title: PUT Create VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.3 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT Create VNF Snapshot Task
    Check HTTP Response Status Code Is    405

PATCH Create VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 7.3.1.38.7
    ...    Test title: PATCH Create VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.4 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH Create VNF Snapshot Task
    Check HTTP Response Status Code Is    405
    
DELETE Create VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 7.3.1.38.8
    ...    Test title: DELETE Create VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.5 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE Create VNF Snapshot Task
    Check HTTP Response Status Code Is    405

*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 
    Integer    response status    200
