*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          NFVMANOLogManagementKeywords.robot
Library           JSONLibrary
Library           OperatingSystem
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false

*** Test Cases ***
POST Individual Log Report - Method not implemented
    [Documentation]    Test ID: 8.3.4.3.1
    ...    Test title: POST Individual Log Report - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new log report.
    ...    Pre-conditions: Logging Job is already created.
    ...    Reference: clause 8.5.5.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The log report is not created.
    Send Post request for Individual Log Report
    Check HTTP Response Status Code Is    405
    Check Postcondition Individual Log Report is not Created

Get Individual Log Report
    [Documentation]    Test ID: 8.3.4.3.2
    ...    Test title: Get Individual Log Report
    ...    Test objective: The objective is to test the retrieval of an individual log report and perform a JSON schema validation of the collected report data structure
    ...    Pre-conditions: One or more log reports are set.
    ...    Reference: clause 8.5.5.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Log Report
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   LogReport
    
Get Individual Log Report (asynchronous)
    [Documentation]    Test ID: 8.3.4.3.3
    ...    Test title: Get Individual Log Report  (asynchronous)
    ...    Test objective: The objective is to test the retrieval of an individual log report is ongoing and no log report is available yet.
    ...    Pre-conditions: One or more log reports are set.
    ...    Reference: clause 8.5.5.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Log Report
    Check HTTP Response Status Code Is    202

Get Individual Log Report with invalid resource endpoint
        [Documentation]    Test ID: 8.3.4.3.4
    ...    Test title: Get Individual Log Report with invalid resource endpoint
    ...    Test objective:  The objective is to test that the retrieval of an individual log report  fails when using an invalid resource endpoint. 
    ...    Pre-conditions: One or more log reports are set.
    ...    Reference: clause 8.5.5.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Log Report with invalid resource endpoint
    Check HTTP Response Status Code Is    404

PUT Individual Log Report - Method not implemented
    [Documentation]    Test ID: 8.3.4.3.5
    ...    Test title: PUT Individual Log Report - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing log report.
    ...    Pre-conditions: One or more log reports are set.
    ...    Reference: clause 8.5.5.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The NFV-MANO log report is not modified by the operation
    Send Put request for Individual Log Report
    Check HTTP Response Status Code Is    405
    Check Postcondition Individual Log Report is Unmodified (Implicit)

PATCH Individual Log Report - Method not implemented
    [Documentation]    Test ID: 8.3.4.3.6
    ...    Test title: PATCH Individual Log Report - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify an existinglog report.
    ...    Pre-conditions: One or more log reports are set.
    ...    Reference: clause 8.5.5.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The log report is not modified by the operation
    Send Patch request for Individual Log Report
    Check HTTP Response Status Code Is    405
    Check Postcondition Individual Log Report is Unmodified (Implicit)

DELETE Individual Log Report - Method not implemented
    [Documentation]    Test ID: 8.3.4.3.7
    ...    Test title: DELETE Individual Log Report - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete an existing log report.
    ...    Pre-conditions: One or more log reports are set.
    ...    Reference: clause 8.5.5.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The log report is not deleted by the operation
    Send Delete request for Individual Log Report
    Check HTTP Response Status Code Is    405
    Check Postcondition Individual Log Report Exists
