** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
POST Change State Operation Occurrence - Method not implemented
    [Documentation]    Test ID: 8.3.1.3.1
    ...    Test title: POST Change State Operation Occurrence - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.8.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for Change State Operation Occurrence
    Check HTTP Response Status Code Is    405
    
GET Change State Operation Occurrence
    [Documentation]    Test ID: 8.3.1.3.2
    ...    Test title: GET Change State Operation Occurrence
    ...    Test objective: The objective is to query status information about multiple change state operation occurrences.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Change State Operation Occurrence
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ChangeStateOpOccs
    
GET Change State Operation Occurrence - invalid attribute-based filter
    [Documentation]    Test ID: 8.3.1.3.3
    ...    Test title: GET Change State Operation Occurrence - invalid attribute-based filter
    ...    Test objective:  The objective is to test that the retrieval of Change State Operation Occurrence fails when using invalid attribute-based filter, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Change State Operation Occurrence with invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails   
    
GET Change State Operation Occurrence - invalid attribute selector
    [Documentation]    Test ID: 8.3.1.3.4
    ...    Test title: GET Change State Operation Occurrence - invalid attribute selector
    ...    Test objective: The objective is to test that the retrieval of Change State Operation Occurrence fails when using invalid attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Change State Operation Occurrence with invalid selector
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails  
    
GET Change State Operation Occurrence - Bad Request Response too Big
    [Documentation]    Test ID: 8.3.1.3.5
    ...    Test title: GET Change State Operation Occurrence - Bad Request Response too Big
    ...    Test objective: The objective is to test that the retrieval of Change State Operation Occurrence fails when response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Change State Operation Occurrence
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET Change State Operation Occurrence with attribute-based filter
    [Documentation]    Test ID: 8.3.1.3.6
    ...    Test title: GET Change State Operation Occurrence with attribute-based filter
    ...    Test objective: The objective is to query status information about multiple change state operation occurrences with attribute filters
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Change State Operation Occurrence with filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ChangeStateOpOcc
    
GET Change State Operation Occurrence with "all_fields" attribute selector
    [Documentation]    Test ID: 8.3.1.3.7
    ...    Test title: GET Change State Operation Occurrence with "all_fields" attribute selector
    ...    Test objective: The objective is to retrieve Change State Operation Occurrence with "all_fields" attribute selector
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Change State Operation Occurrence with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ChangeStateOpOcc
    
GET Change State Operation Occurrence with "exclude_default" attribute selector
    [Documentation]    Test ID: 8.3.1.3.8
    ...    Test title: GET Change State Operation Occurrence with "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve Change State Operation Occurrence with "exclude_default" attribute selector
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: 
    ...    Post-Conditions: 
    Get Change State Operation Occurrence with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ChangeStateOpOcc

    
GET Change State Operation Occurrence with "fields" attribute selector
    [Documentation]    Test ID: 8.3.1.3.9
    ...    Test title: GET Change State Operation Occurrence with "fields" attribute selector
    ...    Test objective: The objective is to retrieve Change State Operation Occurrence with fields attribute selector
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: 
    ...    Post-Conditions: 
    Get Change State Operation Occurrence with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ChangeStateOpOcc
     
GET Change State Operation Occurrence with "exclude_fields" attribute selector
    [Documentation]    Test ID: 8.3.1.3.10
    ...    Test title: GET Change State Operation Occurrence with "exclude_fields" attribute selector
    ...    Test objective: The objective is to retrieve Change State Operation Occurrence with "exclude_fields" attribute selector
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: 
    ...    Post-Conditions: none
    Get Change State Operation Occurrence with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ChangeStateOpOcc
    
GET Change State Operation Occurrence with Paged Response
    [Documentation]    Test ID: 8.3.1.3.11
    ...    Test title: GET Change State Operation Occurrence with Paged Response
    ...    Test objective: The objective is to query Change State Operation Occurrence to get Paged Response.
    ...    Pre-conditions:  
    ...    Reference: clause 5.5.8.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: 
    ...    Post-Conditions: 
    Get Change State Operation Occurrence
    Check HTTP Response Status Code Is    200
    Check LINK in Header

PUT Change State Operation Occurrence - Method not implemented
    [Documentation]    Test ID: 8.3.1.3.12
    ...    Test title: PUT Change State Operation Occurrence - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemeted.
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.8.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Put request for Change State Operation Occurrence
    Check HTTP Response Status Code Is    405
    
PATCH Change State Operation Occurrence - Method not implemented
    [Documentation]    Test ID: 8.3.1.3.13
    ...    Test title: PATCH Change State Operation Occurrence - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemeted.
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.8.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Patch request for Change State Operation Occurrence
    Check HTTP Response Status Code Is    405

DELETE Change State Operation Occurrence - Method not implemented
    [Documentation]    Test ID: 8.3.1.3.14
    ...    Test title: DELETE Change State Operation Occurrence - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemeted.
    ...    Pre-conditions: 
    ...    Reference: clause 5.5.8.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: 
    Send Delete request for Change State Operation Occurrence
    Check HTTP Response Status Code Is    405