*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary
*** Test Cases ***
POST NFV-MANO functional entity application state change
    [Documentation]    Test ID: 8.3.1.2.1
    ...    Test title: POST NFV-MANO functional entity application state change
    ...    Test objective: The objective is to request state change of the NFV-MANO functional entity application.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.7.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for NFV-MANO functional entity application state change
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id
    
POST NFV-MANO functional entity application state change - Conflict
    [Documentation]    Test ID: 8.3.1.2.2
    ...    Test title: POST NFV-MANO functional entity application state change - Conflict
    ...    Test objective: The objective is to test that request to change the state of the NFV-MANO functional entity application failed due to a conflict with the state of the NFV-MANO entity resource and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.7.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for NFV-MANO functional entity application state change
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET NFV-MANO functional entity application state change - Method not implemented
    [Documentation]    Test ID: 8.3.1.2.3
    ...    Test title: GET NFV-MANO functional entity application state change - Method not implemented
    ...    Test objective: The objective is to test that GET method is not allowed to retrieve the changed state of the NFV-MANO functional entity application.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.7.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Get request for NFV-MANO functional entity application state change
    Check HTTP Response Status Code Is    405
    
PUT NFV-MANO functional entity application state change - Method not implemented
    [Documentation]    Test ID: 8.3.1.2.4
    ...    Test title: PUT NFV-MANO functional entity application state change - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update the changed state of the NFV-MANO functional entity application.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.7.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for NFV-MANO functional entity application state change
    Check HTTP Response Status Code Is    405
    
PATCH NFV-MANO functional entity application state change - Method not implemented
    [Documentation]    Test ID: 8.3.1.2.5
    ...    Test title: PATCH NFV-MANO functional entity application state change - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update the changed state of the NFV-MANO functional entity application.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.7.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for NFV-MANO functional entity application state change
    Check HTTP Response Status Code Is    405
    
DELETE NFV-MANO functional entity application state change - Method not implemented
    [Documentation]    Test ID: 8.3.1.2.6
    ...    Test title: DELETE NFV-MANO functional entity application state change - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete the changed state of the NFV-MANO functional entity application.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.7.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for NFV-MANO functional entity application state change
    Check HTTP Response Status Code Is    405