# NFV API Conformance Test Specification (NFV-TST 010)

This repository hosts the NFV API Conformance test specification for 
the APIs defined in ETSI NFV GS [SOL002](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/002/03.03.01_60/gs_NFV-SOL002v030301p.pdf), 
[SOL003](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/003/03.03.01_60/gs_NFV-SOL003v030301p.pdf), 
[SOL005](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/005/03.03.01_60/gs_NFV-SOL005v030301p.pdf), in their versions 
v3.3.1.

More information and download is available at [DGS/NFV-TST010ed331](https://portal.etsi.org/webapp/WorkProgram/Report_WorkItem.asp?WKI_ID=58931).

**{- Disclaimer: The content of this repository is related to a DRAFT, i.e. a working document, of ETSI ISG NFV.-}**

{-It is provided for information only and is still under development. The content may be updated, replaced, or removed at any time. Do not use as reference material.-}

The latest draft may be downloaded at the [ISG NFV open area](https://docbox.etsi.org/isg/nfv/open/Drafts/).

## Overview

The Test Specification is built as a collection of [Robot Framework](robotframework.org/) Test Description. [Robot Framework](robotframework.org/) is a generic test automation framework for acceptance testing and acceptance test-driven development.

More information at [NFV API Conformance Test Specification wiki](https://forge.etsi.org/rep/nfv/api-tests/wikis/NFV-API-Conformance-Test-Specification).

## How to raise issues

Please report errors, bugs or other issues [here](https://forge.etsi.org/rep/nfv/api-tests/issues).

## How to contribute

ETSI Forge uses Gitlab to manage submissions to the repository.
For more information on setting up your environment and contributing, you may refer to the [ETSI Forge wiki](https://forge.etsi.org/wiki/index.php/Main_Page).


