*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Library           JSONLibrary
Resource          environment/IndividualPmJob.txt
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false

*** Test Cases ***
POST Individual NFV-MANO Performance Job - Method not implemented
    [Documentation]    Test ID: 8.3.2.2.1
    ...    Test title: POST Individual NFV-MANO Performance Job - method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new NFV-MANO Performance Monitoring Job
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.4.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    405
    
GET individual NFV-MANO Performance Job
    [Documentation]    Test ID: 8.3.2.2.2
    ...    Test title: Get individual NFV-MANO Performance Job
    ...    Test objective: The objective is to test the retrieval of an individual performance monitoring job and perform a JSON schema validation of the collected job data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated.
    ...    Reference: clause 6.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmJob
    Check HTTP Response Body Pm Job Identifier matches the requested Pm Job

GET individual NFV-MANO Performance Job with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.2.3
    ...    Test title: Get individual NFV-MANO Performance Job with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual performance monitoring job fails when using an invalid resource identifier, and perform the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual NFV-MANO Performance Job with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PUT Individual NFV-MANO Performance Job - Method not implemented
    [Documentation]    Test ID: 8.3.2.2.4
    ...    Test title: PUT Individual NFV-MANO Performance Job - method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing NFV-MANO Performance Monitoring Job
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    405

PATCH Individual NFV-MANO Performance Job - Method not implemented
    [Documentation]    Test ID: 8.3.2.2.5
    ...    Test title: PATCH Individual NFV-MANO Performance Job - method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify an existing new NFV-MANO Performance Monitoring Job
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    405

DELETE Individual NFV-MANO Performance Job
    [Documentation]    Test ID: 8.3.2.2.6
    ...    Test title: Delete Individual NFV-MANO Performance Job
    ...    Test objective: The objective is to test the deletion of an individual performance monitoring job
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The NFV-MANO Performance Job is no more available.   
    Send Delete request for individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    204
    Check Postcondition NFV-MANO Pm Job is Deleted

DELETE Individual NFV-MANO Performance Job with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.2.7
    ...    Test title: Delete individual NFV-MANO Performance Job with invalid resource identifier
    ...    Test objective: The objective is to test that the deletion of an individual NFV-MANO performance monitoring job fails when using an invalid resource identifier
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for individual NFV-MANO Performance Job with invalid resource identifier
    Check HTTP Response Status Code Is    404
    
*** Keywords ***
GET individual NFV-MANO Performance Job
    Log    Trying to get a Pm Job 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET individual NFV-MANO Performance Job with invalid resource identifier  
    Log    Trying to perform a negative get, using erroneous PM Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${erroneousPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual NFV-MANO Performance Job
    Log    Trying to delete an existing PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Delete request for individual NFV-MANO Performance Job with invalid resource identifier
    Log    Trying to perform a negative delete, using erroneous PM Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${erroneousPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post request for individual NFV-MANO Performance Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${newPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Put request for individual NFV-MANO Performance Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for individual NFV-MANO Performance Job    
    Log    Trying to perform a PATCH (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check Postcondition NFV-MANO Pm Job is Deleted
    Log    Check Postcondition
    GET individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    404

Check HTTP Response Body Pm Job Identifier matches the requested Pm Job
    Log    Going to validate Pm Job info retrieved
    Should Be Equal    ${response['body']['id']}    ${pmJobId} 
    Log    Pm Job identifier as expected
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}	.schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
