*** Settings ***
Resource    environment/variables.txt
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    MockServerLibrary 
Library    OperatingSystem
Library    BuiltIn
Library    JSONLibrary
Library    Collections
Library    JSONSchemaLibrary    schemas/
Library    Process
Library    String

*** Keywords ***
GET all NS Performance Monitoring Jobs
    Log    Trying to get all PM Jobs present in the NFVO
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NS Performance Monitoring Jobs with attribute-based filter
    Log    Trying to get all PM Jobs present in the NFVO, using filter params
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?${POS_FILTER}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NS Performance Monitoring Jobs with all_fields attribute selector
    Log    Trying to get all PM Jobs present in the NFVO, using 'all_fields' filter
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NS Performance Monitoring Jobs with exclude_default attribute selector
    Log    Trying to get all NS Packages present in the NFVO, using filter params
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NS Performance Monitoring Jobs with fields attribute selector
    Log    Trying to get all NS Packages present in the NFVO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFVO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NS Performance Monitoring Jobs with fields and exclude_default attribute selector
    Log    Trying to get all NS Packages present in the NFVO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFVO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?fields=${fields}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NS Performance Monitoring Jobs with exclude attribute selector
    Log    Trying to get all NS Packages present in the NFVO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFVO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?exclude=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NS Performance Monitoring Jobs with invalid attribute-based filter
    Log    Trying to get all PM Jobs present in the NFVO, using an erroneous filter param
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?${NEG_FILTER}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NS Performance Monitoring Jobs with invalid resource endpoint    
    Log    Trying to perform a GET on a erroneous URI
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_job    # wrong URI /pm_job instead of /pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post Request Create new NS Performance Monitoring Job
    Log    Creating a new PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreatePmJobRequest.json
    ${body}=        Format String   ${template}     pmJobId=${pmJobId}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send PUT Request for all NS Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send PATCH Request for all NS Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send DELETE Request for all NS Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

    
Check Postcondition PmJob Exists
    Log    Checking that Pm Job exists
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PmJob
    
Check HTTP Response Body PmJobs Matches the requested exclude selector
    Log    Checking that reports element is missing
    ${reports}=    Get Value From Json    ${response['body']}    $..reports
    Should Be Empty    ${reports}
    Log    Checking that reports element is missing
    ${criteria}=    Get Value From Json    ${response['body']}    $..criteria
    Should Be Empty    ${criteria}
    Log    Reports element is empty as expected

Check HTTP Response Body PmJobs Matches the requested selector
    Log    Trying to validate criteria schema
    ${criteria}=    Get Value From Json    ${response['body']}    $..criteria
    Validate Json    criteria.schema.json    ${criteria}
    Log    Validation for criteria schema OK
    Log    Trying to validate criteria schema
    ${reports}=    Get Value From Json    ${response['body']}    $..reports
    Validate Json    reports.schema.json    ${reports}
    Log    Validation for reports schema OK
    
Check HTTP Response Body PmJobs Matches the requested exclude_default selector
    Log    Checking that reports element is missing
    ${reports}=    Get Value From Json    ${response['body']}    $..reports
    Should Be Empty    ${reports}
    Log    Reports element is empty as expected

Check HTTP Response Body PmJobs Matches the requested all_fields selector
    Log    Trying to validate criteria schema
    ${criteria}=    Get Value From Json    ${response['body']}    $..criteria
    Validate Json    criteria.schema.json    ${criteria}
    Log    Validation for criteria schema OK
    Log    Trying to validate criteria schema
    ${reports}=    Get Value From Json    ${response['body']}    $..reports
    Validate Json    reports.schema.json    ${reports}
    Log    Validation for reports schema OK
    Log    Validating _links schema
    ${links}=    Get Value From Json    ${response['body']}    $.._links
    Validate Json    links.schema.json    ${links}
    Log    Validation for _links schema OK
    
Check HTTP Response Body PmJobs Matches the requested Attribute-Based Filter 
    Log    Checking that attribute-based filter is matched
    ${user}=    Get Value From Json    ${response['body']}    $..userDefinedData
    Validate Json    UserDefinedData.schema.json    ${user[0]}
    Log    Validation for schema OK

Check HTTP Response Body PmJobs Do Not Contain reports
    Log    Checking that field element is missing
    ${reports}=    Get Value From Json    ${response['body']}    $..reports
    Should Be Empty    ${reports}
    Log    Reports element is empty as expected

GET individual NS Performance Job
    Log    Trying to get a Pm Job present in the NFVO Catalogue
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET individual NS Performance Job with invalid resource identifier  
    Log    Trying to perform a negative get, using erroneous PM Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${erroneousPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual NS Performance Job
    Log    Trying to delete an existing PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Delete request for individual NS Performance Job with invalid resource identifier
    Log    Trying to perform a negative delete, using erroneous PM Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${erroneousPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post request for individual NS Performance Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${newPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Put request for individual NS Performance Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for individual NS Performance Job    
    Log    Trying to perform a PATCH 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/PmJobModifications.json
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check Postcondition NS Performance Job is not Created
    Log    Trying to get a new Pm Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${newPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    404

Check Postcondition NS Performance Job is Unmodified (Implicit)
    Log    Check Postcondition VNF PM job is not modified
    GET individual NS Performance Job
    Log    Check Response matches original VNF Pm Job
    ${pmJob}=    evaluate    json.loads('''${response['body']}''')    json
    Should Be Equal    ${origresponse['body']['id']}    ${pmJob.id}
    Should Be Equal    ${origresponse['body']['criteria']}    ${pmJob.criteria}
    Should Be Equal    ${origresponse['body']['_links']}    ${pmJob._links}

Check Postcondition NS Pm Job is Deleted
    Log    Check Postcondition
    GET individual NS Performance Job
    Check HTTP Response Status Code Is    404

Check HTTP Response Body Pm Job Identifier matches the requested Pm Job
    Log    Going to validate Pm Job info retrieved
    Should Be Equal    ${response['body']['id']}    ${pmJobId} 
    Log    Pm Job identifier as expected

Get Individual Performance Report
    Log    Trying to get a performance report present in the NFVO
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Individual Performance Report with invalid resource endpoint
    Log    Trying to get a performance report with invalid resource endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${erroneousReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post request for Individual Performance Report
    Log    Trying to create new performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${newReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Put request for Individual Performance Report
    Log    Trying to update performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for Individual Performance Report
    Log    Trying to update performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for Individual Performance Report
    Log    Trying to delete performance report   
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET all Performance Thresholds
    Log    Trying to get all thresholds present in the NFVO    
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Performance Thresholds with attribute-based filter
    Log    Trying to get thresholds present in the NFVO with filter
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds?${FILTER_OK_Threshold}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Performance Thresholds with invalid attribute-based filter
    Log    Trying to get thresholds present in the NFVO with invalid filter
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds?${FILTER_KO}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NS performance Thresholds with invalid resource endpoint
    Log    Trying to get thresholds present in the NFVO with invalid resource endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/threshold
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post Request Create new Performance Threshold
    Log    Creating a new THreshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    ${template}=    Get File    jsons/CreateThresholdRequest.json
    ${body}=        Format String   ${template}     pmJobId=${pmJobId}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send PUT Request for all Performance Thresholds
    Log    PUT THresholds
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send PATCH Request for all Performance Thresholds
    Log    PUT THresholds
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send DELETE Request for all Performance Thresholds
    Log    DELETE THresholds
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check Postcondition Threshold Exists
    Log    Checking that Threshold exists
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Threshold
        
Check HTTP Response Body Thresholds match the requested attribute-based filter
    Log    Checking that attribute-based filter is matched
    @{words} =    Split String    ${FILTER_OK_Threshold}       ,${SEPERATOR} 
    Should Be Equal As Strings    ${response['body'][0]['objectInstanceId']}    @{words}[1]
    

GET Individual NS performance Threshold
    Log    Trying to get a Threhsold present in the NFVO
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET individual NS performance Threshold with invalid resource identifier
    Log    Trying to get a Threhsold with invalid resource endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${erroneousThresholdId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual NS performance Threshold
    Log    Trying to delete a Threhsold in the NFVO
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual NS performance Threshold with invalid resource identifier
    Log    Trying to delete a Threhsold in the NFVO with invalid id
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${erroneousThresholdId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post request for individual NS performance Threshold
    Log    Trying to create new threshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${newThresholdId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Put request for individual NS performance Threshold
    Log    Trying to PUT threshold
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Patch request for individual NS performance Threshold
    Log    Trying to PUT threshold
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/ThresholdModifications.json
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check Postcondition NS performance Threshold is Unmodified (Implicit)
    Log    Check postconidtion threshold not modified
    GET individual NS performance Threshold
    Log    Check Response matches original VNF Threshold
    ${threshold}=    evaluate    json.loads('''${response['body']}''')    json
    Should Be Equal    ${origresponse['body']['id']}    ${threshold.id}
    Should Be Equal    ${origresponse['body']['criteria']}    ${threshold.criteria}

Check Postcondition NS performance Threshold is Deleted
    Log    Check Postcondition Threshold is deleted
    GET individual NS performance Threshold
    Check HTTP Response Status Code Is    404
    
Check HTTP Response Body Threshold Identifier matches the requested Threshold
    Log    Trying to check response ID
    Should Be Equal    ${response['body']['id']}    ${thresholdId} 
    Log    Pm Job identifier as expected

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK  


Check HTTP Response Body Is Empty
    Should Be Empty    ${response['body']}    
    Log    No json schema is provided. Validation OK  
 
Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present

Create Sessions
    Pass Execution If    ${NFVO_CHECKS_NOTIF_ENDPOINT} == 0    MockServer not started as NFVO is not checking the notification endpoint
    Start Process  java  -jar  ${MOCK_SERVER_JAR}    -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
       
Check Notification Endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{headers} =	Create Dictionary	Content-Type=application/json  
    &{notification_response}=  Create Mock Response	headers=${headers}  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests  ${callback_endpoint}
    
Check HTTP Response Header Contains Location
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}