/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import java.util.concurrent.TimeUnit;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.DTO;

public class TimeToLiveDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<TimeToLive> {
    private TimeUnit timeUnit;
    private Long timeToLive;
    private boolean unlimited;

    public TimeToLiveDTO(TimeToLive timeToLive) {
        this.timeUnit = timeToLive.getTimeUnit();
        this.timeToLive = timeToLive.getTimeToLive();
        this.unlimited = timeToLive.isUnlimited();
    }

    public TimeToLiveDTO() {
    }

    @Override
    public TimeToLive buildObject() {
        if (this.unlimited) {
            return TimeToLive.unlimited();
        }
        return TimeToLive.exactly(this.timeUnit, this.timeToLive);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }
}

