*** Settings ***
Documentation     This Clause defines all the resources and methods provided by the NS LCM coordination interface.
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Resource          NSLCMCoordKeywords.robot
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library           OperatingSystem

*** Test Cases ***
POST an individual coordination action of an LCM operation occurrence - method not implemented
    [Documentation]    # Test ID: 5.3.1.1.1
    ...    Test title: POST an individual coordination action of an LCM operation occurrence
    ...    Test objective: The objective is to test that the POST method is not allowed to submit a new individuaal coordination requests information
    ...    Pre-conditions: One or more LCM Coordinations have been requested
    ...    Reference: Clause 12.4.3.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST an individual Coordination of an LCM operation occurrence
    Check HTTP Response Status Code Is    405
    

Get information about a finished coordination task 
    [Documentation]    # Test ID: 5.3.1.1.11
    ...    Test title:  Request information related to a terminated coordination task
    ...    Test objective: The objective is to retrieve information about an individual coordination task and perform a JSON schema validation.
    ...    Pre-conditions: Individual coordination task is terminated
    ...    Reference: Clause 12.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Retrieve information about a finished coordination task
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   LcmCoord


Get information about an ongoing coordination task 
    [Documentation]    # Test ID: 5.3.1.1.11
    ...    Test title:  Request information related to an ongoing coordination task
    ...    Test objective: The objective is to retrieve information about an individual coordination task that is still in running or is in the process of being cancelled
    ...    Pre-conditions: Individual coordination task is still ongoing or is in the process of being cancelled
    ...    Reference: Clause 12.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Retrieve information about an ongoing coordination task
    Check HTTP Response Status Code Is    202


Get information about an invalid coordination task 
    [Documentation]    # Test ID: 5.3.1.1.11
    ...    Test title:  Request information related to an invalid coordination task
    ...    Test objective: The objective is to try to read an individual coordination task
    ...    Pre-conditions: Individual coordination task is not present
    ...    Reference: Clause 12.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Retrieve information about an ongoing coordination task
    Check HTTP Response Status Code Is    404


Get information about a finished coordination task without authentication
    [Documentation]    # Test ID: 5.3.1.1.11
    ...    Test title:  Request information related to a finished coordination task without authentication
    ...    Test objective: The objective is to try to read an individual coordination task without using authentication
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Retrieve information about an ongoing coordination task
    Check HTTP Response Status Code Is    401


PUT an individual coordination action of an LCM operation occurrence - method not implemented
    [Documentation]    # Test ID: 5.3.1.1.1
    ...    Test title: PUT an individual coordination action of an LCM operation occurrence
    ...    Test objective: The objective is to test that the PUT method is not allowed to modify an individual coordination action
    ...    Pre-conditions: One or more LCM Coordinations have been requested
    ...    Reference: Clause 12.4.3.3.3 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT an individual coordination action of an LCM operation occurrence
    Check HTTP Response Status Code Is    405


PATCH an individual coordination action of an LCM operation occurrence - method not implemented
    [Documentation]    # Test ID: 5.3.1.1.1
    ...    Test title: PATCH an individual coordination action of an LCM operation occurrence
    ...    Test objective: The objective is to test that the PATCH method is not allowed to modify an individual coordination action
    ...    Pre-conditions: One or more LCM Coordinations have been requested
    ...    Reference: Clause 12.4.3.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH an individual coordination action of an LCM operation occurrence
    Check HTTP Response Status Code Is    405


DELETE an individual coordination action of an LCM operation occurrence - method not implemented
    [Documentation]    # Test ID: 5.3.1.1.1
    ...    Test title: DELETE an individual coordination action of an LCM operation occurrence
    ...    Test objective: The objective is to test that the DELETE method is not allowed to remove an individual coordination action
    ...    Pre-conditions: One or more LCM Coordinations have been requested
    ...    Reference: Clause 12.4.3.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE an individual coordination action of an LCM operation occurrence
    Check HTTP Response Status Code Is    405
