/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.verify;

import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class VerificationTimes
extends ObjectWithReflectiveEqualsHashCodeToString {
    private final int atLeast;
    private final int atMost;

    private VerificationTimes(int atLeast, int atMost) {
        this.atMost = atMost;
        this.atLeast = atLeast;
    }

    public static VerificationTimes once() {
        return new VerificationTimes(1, 1);
    }

    public static VerificationTimes exactly(int count) {
        return new VerificationTimes(count, count);
    }

    public static VerificationTimes atLeast(int count) {
        return new VerificationTimes(count, -1);
    }

    public static VerificationTimes atMost(int count) {
        return new VerificationTimes(-1, count);
    }

    public static VerificationTimes between(int atLeast, int atMost) {
        return new VerificationTimes(atLeast, atMost);
    }

    public int getAtLeast() {
        return this.atLeast;
    }

    public int getAtMost() {
        return this.atMost;
    }

    public boolean matches(int times) {
        if (this.atLeast != -1 && times < this.atLeast) {
            return false;
        }
        return this.atMost == -1 || times <= this.atMost;
    }

    @Override
    public String toString() {
        String string = "";
        if (this.atLeast == this.atMost) {
            string = string + "exactly ";
            string = this.atMost == 1 ? string + "once" : string + this.atMost + " times";
        } else if (this.atMost == -1) {
            string = string + "at least ";
            string = this.atLeast == 1 ? string + "once" : string + this.atLeast + " times";
        } else if (this.atLeast == -1) {
            string = string + "at most ";
            string = this.atMost == 1 ? string + "once" : string + this.atMost + " times";
        } else {
            string = string + "between " + this.atLeast + " and " + this.atMost + " times";
        }
        return string;
    }
}

