*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          VNFPackageManagementKeywords.robot
Library           OperatingSystem
Library           JSONLibrary
Library           String
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Package Onboarding Notification
    [Documentation]    Test ID: 5.3.5.13.1
    ...    Test title: VNF Package Onboarding Notification
    ...    Test objective: The objective is to test that VNF Package Onboarding Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A VNF package subscription for onboarding notifications is available in the NFVO.
    ...    Reference: Clause 9.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Package Onboarding Notification
    Check HTTP Response Status Code Is    204
    
VNF Package Change Notification
    [Documentation]    Test ID: 5.3.5.13.2
    ...    Test title: VNF Package Change Notification
    ...    Test objective: The objective is to test that VNF Package Change Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A VNF package subscription for change notifications is available in the NFVO.
    ...    Reference: Clause 9.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Package Change Notification
    Check HTTP Response Status Code Is    204

*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    PkgmSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Post VNF Package Onboarding Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Run Keyword If    ${check_descriptors} == 1    Add VNF Descriptor Content to VNF Package
    ${template} =    Get File    jsons/VnfPackageOnboardingNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfPkgId=${vnfPkgId}    vnfdId=${descriptor_id}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Post VNF Package Change Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Run Keyword If    ${check_descriptors} == 1    Add VNF Descriptor Content to VNF Package
    ${template} =    Get File    jsons/VnfPackageChangeNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfPkgId=${vnfPkgId}    vnfdId=${descriptor_id}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}