*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          VNFPackageManagementKeywords.robot    
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false

*** Test Cases ***
Get Access configuration for external artifacts
    [Documentation]    Test ID: 5.3.5.10.1
    ...    Test title: Get Access configuration for external artifacts
    ...    Test objective: The objective is to test the GET method reads the access configuration information that is used by the NFVO to get the content of external VNF package artifacts and perform a JSON schema and content validation of the collected data structure
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get access configuration information for external artifacts
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   ExternalArtifactsAccessConfig

Get Access configuration for external artifacts - Not Found
    [Documentation]    Test ID: 5.3.5.10.2
    ...    Test title: Get Access configuration for external artifacts - Not Found
    ...    Test objective: The objective is to test that the retrieval of access configuration information that is used by the NFVO to get the content of external VNF package artifacts fails because resource is not present.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get access configuration information for external artifacts
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PUT Access configuration for external artifacts 
    [Documentation]    Test ID: 5.3.5.10.3
    ...    Test title: Access configuration for external artifacts
    ...    Test objective: The objective is to test that PUT method provides the access configuration information for the NFVO to download the content of external VNF package artifacts.
    ...    Pre-conditions:  the individual VNF package resource shall have been created, and the value of "onboardingState" attribute shall equal to "CREATED" or "ERROR"
    ...    Reference: Clause 9.4.4a.3.3 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Check Postcondition individual VNF Package is created
    Send PUT Request to access configuration information for external artifacts
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   ExternalArtifactsAccessConfig
    
PUT Access configuration for external artifacts - Downloading
    [Documentation]    Test ID: 5.3.5.10.4
    ...    Test title: Access configuration for external artifacts - Downloading
    ...    Test objective: The objective is to test that VNF package has been uploaded successfully previously, to indicate that the access configuration information has been stored successfully by the NFVO and the NFVO now starts downloading external artifacts.
    ...    Pre-conditions:  the individual VNF package resource shall have been created, and the value of "onboardingState" attribute shall equal to "CREATED" or "ERROR"
    ...    Reference: Clause 9.4.4a.3.3 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Check Postcondition individual VNF Package is created
    Send PUT Request to access configuration information for external artifacts
    Check HTTP Response Status Code Is    202
    
PUT Access configuration for external artifacts - Conflict
    [Documentation]    Test ID: 5.3.5.10.5
    ...    Test title: Access configuration for external artifacts
    ...    Test objective: The objective is to test that PUT method provides the access configuration information for the NFVO to download the content of external VNF package artifacts.
    ...    Pre-conditions:  the individual VNF package resource shall have been created, and the value of "onboardingState" attribute is neither "CREATED" nor "ERROR"
    ...    Reference: Clause 9.4.4a.3.3 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request to access configuration information for external artifacts
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
POST Access configuration for external artifacts - Method not implemented
    [Documentation]    Test ID: 5.3.5.10.6
    ...    Test title: POST Access configuration for external artifacts - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create access configuration for external artifacts
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.4a.3.1 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for access configuration for external artifacts
    Check HTTP Response Status Code Is    405

PATCH Access configuration for external artifacts - Method not implemented
    [Documentation]    Test ID: 5.3.5.10.7
    ...    Test title: PATCH Access configuration for external artifacts - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update access configuration for external artifacts
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.4a.3.4 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for access configuration for external artifacts
    Check HTTP Response Status Code Is    405

DELETE Access configuration for external artifacts - Method not implemented
    [Documentation]    Test ID: 5.3.5.10.8
    ...    Test title: DELETE Access configuration for external artifacts - Method not implemented
    ...    Test objective: The objective is to test that DELETE  method is not allowed to delete access configuration for external artifacts
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.4a.3.5 - ETSI GS NFV-SOL 005 [3] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for Access configuration for external artifacts
    Check HTTP Response Status Code Is    405