*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Resource          NSDManagementKeywords.robot
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library           OperatingSystem

*** Test Cases ***
Get single file NSD in Plain Format
    [Documentation]    Test ID: 5.3.1.11.1
    ...    Test title: Get single file NSD in Plain Format
    ...    Test objective: The objective is to test the retrieval of the NSD in plain format within a NSD archive and perform a validation that returned content is in plain format
    ...    Pre-conditions: One or more NSDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NSD is implemented as a single file
    ...    Post-Conditions: none
    Get single file NSD in Plain Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain

Get NSD in Zip Format
    [Documentation]    Test ID: 5.3.1.11.2
    ...    Test title: Get NSD in Zip Format
    ...    Test objective: The objective is to test the retrieval of the NSD in zip format within a NSD archive and perform a validation that returned content is in zip format
    ...    Pre-conditions: One or more NSDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NSD in Zip Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip

Get single file NSD in Plain or Zip Format 
    [Documentation]    Test ID: 5.3.1.11.3
    ...    Test title: Get single file NSDin Plain or Zip Format
    ...    Test objective: The objective is to test the retrieval of the single file NSD within a NSD archive when requesting Plain or Zip format to NFVO by including both formats in the request, and perform a validation that response is in Plain or Zip format
    ...    Pre-conditions: One or more NSDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NSD is implemented as a single file
    ...    Post-Conditions: none
    Get single file NSD in Plain or Zip Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is Any of   text/plain    application/zip
    
Get multi file NSD in Plain or Zip Format
    [Documentation]    Test ID: 5.3.1.11.4
    ...    Test title: Get multi file NSD in Plain or Zip Format
    ...    Test objective: The objective is to test the retrieval of the multi file NSD within a NSD archive when requesting Plain or Zip format to NFVO by including both formats in the request, and perform a validation that returned content is in Zip format
    ...    Pre-conditions: One or more NSDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NSD is implemented as a multi file
    ...    Post-Conditions: none
    Get multi file NSD in Plain or Zip Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip

Get multi file NSD in Plain Format
    [Documentation]    Test ID: 5.3.1.11.5
    ...    Test title: Get multi file NSD in Plain Format
    ...    Test objective: The objective is to test that the retrieval of the multi file NSD within a NSD archive fails when requesting it in Plain format, and perform a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: One or more NSDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NSD is implemented as a multi file
    ...    Post-Conditions: none
    Get multi file NSD in Plain Format
    Check HTTP Response Status Code Is    406
    Check HTTP Response Body Json Schema Is   ProblemDetails

Get NSD Content with invalid resource identifier
    [Documentation]    Test ID: 5.3.1.11.6
    ...    Test title: Get NSD Content with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of the NSD within a NSD archive fails when using an invalid resource identifier
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NSD with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

Get NSD with conflict due to onboarding state
    [Documentation]    Test ID: 5.3.1.11.7
    ...    Test title: Get NSD with conflict due to onboarding state
    ...    Test objective: The objective is to test that the retrieval of the NSD within a NSD archive fails due to a conflict when the NSD is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the NSD is different from ONBOARDED.
    ...    Reference: Clause 5.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get NSD with conflict due to onboarding state
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails    
    
Get NSD with security information
    [Documentation]    Test ID: 5.3.1.11.8
    ...    Test title: Get NSD with security information
    ...    Test objective: The objective is to test the retrieval of the NSD within a NSD archive shall include in the ZIP archive the security information when requested with "include_signature" parameter
    ...    Pre-conditions: One or more NSDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.4a.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NSD with security information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip          

POST NSD - Method not implemented
    [Documentation]    Test ID: 5.3.1.11.9
    ...    Test title: POST NSD - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new Network Service Descriptor
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4a.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for NSD
    Check HTTP Response Status Code Is    405
    
PUT NSD - Method not implemented
    [Documentation]    Test ID: 5.3.1.11.10
    ...    Test title: PUT NSD - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update Network Service Descriptor
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4a.3.3 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for NSD
    Check HTTP Response Status Code Is    405

PATCH NSD - Method not implemented
    [Documentation]    Test ID: 5.3.1.11.11
    ...    Test title: PATCH NSD - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update Network Service Descriptor
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4a.3.4 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for NSD
    Check HTTP Response Status Code Is    405

DELETE NSD - Method not implemented
    [Documentation]    Test ID: 5.3.1.11.12
    ...    Test title: DELETE NSD - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete Network Service Descriptor
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4a.3.5 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for NSD
    Check HTTP Response Status Code Is    405