*** Settings ***
Library    String
Library    OperatingSystem
Library    JSONSchemaLibrary    schemas/
Resource   environment/variables.txt
Library    JSONLibrary
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
Performance Information Available Notification
    [Documentation]    Test ID: 7.3.4.10.1
    ...    Test title: Performance Information Available Notification
    ...    Test objective: The objective is to test that the POST request triggers Performance Information Available Notification.
    ...    Pre-conditions: A VNF performance job is created, and a subscription for performance information available notification is available in the VNFM.
    ...    Reference: Clause 6.4.9.3.1 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Performance Information Available Notification
    Check HTTP Response Status Code Is    204
    
Threshold Crossed Notification
    [Documentation]    Test ID: 7.3.4.10.2
    ...    Test title: Threshold Crossed Notification
    ...    Test objective: The objective is to test that the POST request triggers Threshold Crossed Notification
    ...    Pre-conditions: A VNF performance job is created, and a subscription for threshold crossed notification is available in the VNFM.
    ...    Reference: Clause 6.4.9.3.1 - ETSI GS NFV-SOL 003 [1] v3.3.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Threshold Crossed Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    Integer    response status    200
    Validate Json    response body    PmJob.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${status} 
    Log    Status code validated

Post Performance Information Available Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body} =    Get File    jsons/PerformanceInformationAvailableNotification.json
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	

Post Threshold Crossed Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body} =    Get File    jsons/ThresholdCrossedNotification.json
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}