*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Suite Setup    Check resource existence

*** Test Cases ***
POST Change current VNF Package Task 
    [Documentation]    Test ID: 6.3.5.22.1
    ...    Test title: POST Change current VNF Package Task
    ...    Test objective: The objective is to test that the POST method changes the current VNF package on which the VNF instance is based.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.11a.3.1 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: in response header Location shall not be null         
    POST Change Current VNF Package Task
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id

POST Change current VNF Package Task - Conflict
    [Documentation]    Test ID: 6.3.5.22.2
    ...    Test title: POST Change current VNF Package Task - Conflict
    ...    Test objective: The objective is to test that the POST method cannot change the current VNF package task when another lifecycle management operation is ongoing. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.11a.3.1 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: There is another lifecycle management operation ongoing.
    ...    Post-Conditions: none
    POST Change Current VNF Package Task
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 
    
GET Change current VNF Package Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.22.3
    ...    Test title: GET Change current VNF Package Task - Method not implemented
    ...    Test objective: The objective is to test that GET method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.11a.3.2 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET Change Current VNF Package Task
    Check HTTP Response Status Code Is    405

PUT Change current VNF Package Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.22.4
    ...    Test title: PUT Change current VNF Package Task - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.11a.3.3 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT Change Current VNF Package Task
    Check HTTP Response Status Code Is    405

PATCH Change current VNF Package Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.22.5
    ...    Test title: PATCH Change current VNF Package Task - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.11a.3.4 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH Change Current VNF Package Task
    Check HTTP Response Status Code Is    405
    
DELETE Change current VNF Package Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.22.6
    ...    Test title: DELETE Change current VNF Package Task - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.11a.3.5 - ETSI GS NFV-SOL 002 [2] v3.3.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE Change Current VNF Package Task
    Check HTTP Response Status Code Is    405

*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 
    Integer    response status    200