*** Settings ***
Resource   environment/variables.txt 
Resource   PolicyManagementKeywords.robot  

*** Test Cases ***
POST Selected Version of an Individual Policy - Method not implemented
    [Documentation]    Test ID: 10.3.1.4.1
    ...    Test title: POST Selected Version of an Individual Policy - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.5.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Selected Version of an Individual Policy
    Check HTTP Response Status Code Is    405

GET Information about the Selected Version of an Individual Policy - Successful
     [Documentation]    Test ID: 10.3.1.4.2
    ...    Test title: GET Information about the Selected Version of an Individual Policy - Successful
    ...    Test objective: The objective is to test The GET method fetches contents of the selected version of an individual policy and check that the HTTP Content-Type header is set according to the type of content.
    ...    Pre-conditions: Individual policy is available in the NFV-MANO. Policy contents are provided in the json/PolicyContent folder.
    ...    Reference: Clause 5.5.5.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The policy content type is either JSON, YAML or ZIP. 
    ...    Post-Conditions: none
    GET Selected Version of an Individual Policy
    Check HTTP Response Status Code Is    200
    Check that the Content-Type Header Is Set
    
GET Information about the Selected Version of an Individual Policy - NOT FOUND
     [Documentation]    Test ID: 10.3.1.4.3
    ...    Test title: GET Information about the Selected Version of an Individual Policy - NOT FOUND
    ...    Test objective: The objective is to test that the information about the selected version of an individual policy fails when using an invalid resource identifier.
    ...    Pre-conditions: The API producer did not find the current representation for the target resource.
    ...    Reference: Clause 5.5.5.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Selected Version of an Individual Policy
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET Information about the Selected Version of an Individual Policy - CREATED STATE
     [Documentation]    Test ID: 10.3.1.4.4
    ...    Test title: GET Information about the Selected Version of an Individual Policy - NOT FOUND
    ...    Test objective: The objective is to test that the information about the selected version of an individual policy is not retrieved when it is in CREATED state.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.5.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Selected Version of an Individual Policy in CREATED STATE
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Selected Version of an individual policy - Method not implemented
     [Documentation]    Test ID: 10.3.1.4.5
    ...    Test title: PUT Selected Version of an individual policy - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.5.3.3 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Selected Version of an Individual Policy
    Check HTTP Response Status Code Is    405

PATCH Selected Version of an individual policy - Method not implemented 
     [Documentation]    Test ID: 10.3.1.4.6
    ...    Test title: PATCH Selected Version of an individual policy - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.5.3.4 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Selected Version of an Individual Policy
    Check HTTP Response Status Code Is    405

DELETE Selected Version of an individual policy - Method not implemented 
     [Documentation]    Test ID: 10.3.1.4.7
    ...    Test title: DELETE Selected Version of an individual policy - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.5.3.5 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Selected Version of an Individual Policy
    Check HTTP Response Status Code Is    405

GET Information about the Selected Version of an Individual Policy with permitted authorization scope
     [Documentation]    Test ID: 10.3.1.4.8
    ...    Test title: GET Information about the Selected Version of an Individual Policy with permitted authorization scope
    ...    Test objective: The objective is to test The GET method fetches contents of the selected version of an individual policy when a permitted authorization scope is used.
    ...    Pre-conditions: Individual policy is available in the NFV-MANO. Policy contents are provided in the json/PolicyContent folder.
    ...    Reference: Clause 5.5.5.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The policy content type is either JSON, YAML or ZIP. 
    ...    Post-Conditions: none
    GET Selected Version of an Individual Policy with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check that the Content-Type Header Is Set

GET Information about the Selected Version of an Individual Policy with not permitted authorization scope
     [Documentation]    Test ID: 10.3.1.4.9
    ...    Test title: GET Information about the Selected Version of an Individual Policy with not permitted authorization scope
    ...    Test objective: The objective is to test the GET method fails to fetch a selected version of an individual policy when a not permitted authorization scope is used.
    ...    Pre-conditions: Individual policy is available in the NFV-MANO. Policy contents are provided in the json/PolicyContent folder.
    ...    Reference: Clause 5.5.5.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The policy content type is either JSON, YAML or ZIP. 
    ...    Post-Conditions: none
    GET Selected Version of an Individual Policy with not permitted authorization scope
    Check HTTP Response Status Code Is    401
