*** Settings ***
Resource   environment/variables.txt 
Resource   PolicyManagementKeywords.robot 

*** Test Cases ***
POST Create a new Policy
    [Documentation]    Test ID: 10.3.1.2.1
    ...    Test title: POST Create a new Policy
    ...    Test objective: The objective is to test that POST method creates a policy.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Policy is created.     
    POST Policies
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    Policy
    Check HTTP Response Header Contains    Location
                
GET Policies
    [Documentation]    Test ID: 10.3.1.2.2
    ...    Test title: GET Policies
    ...    Test objective: The objective is to test that GET method retrieves the list of existing policies.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Policies
    Check HTTP Response Status Code Is  200
    Check HTTP Response Body Json Schema Is  Policies

GET Policies - Filter
    [Documentation]    Test ID: 10.3.1.2.3
    ...    Test title: GET Policies - Filter
    ...    Test objective: The objective is to GET the list of existing policies using a filter.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Policies with filter
    Check HTTP Response Status Code Is  200
    Check HTTP Response Body Json Schema Is  Policies
    
GET Policies - Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 10.3.1.2.4
    ...    Test title: GET Policies - Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to GET the list of existing policies using an invalid filter.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Policies - invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Policies - Bad Request Response too Big
    [Documentation]    Test ID: 10.3.1.2.5
    ...    Test title: GET Policies - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of existing policies list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: NFV-MANO does not support paged response.
    ...    Post-Conditions: none 
    GET Policies without Paging support
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET Policies with "all_fields" attribute selector
    [Documentation]    Test ID: 10.3.1.2.6
    ...    Test title: GET Policies with "all_fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of existing policies with "all_fields" attribute selector.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none 
    ...    Post-Conditions: none
    Get Policies with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Policies

GET Policies with "exclude_default" attribute selector
    [Documentation]    Test ID: 10.3.1.2.7
    ...    Test title: GET policies with "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve the list of existing policies with "exclude_default"s attribute selector.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get Policies with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Policies

GET Policies with "fields" attribute selector
    [Documentation]    Test ID: 10.3.1.2.8
    ...    Test title: GET Policies with "fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of existing policies with "fields" attribute selector.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get Policies with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Policies

GET Policies with "exclude_fields" attribute selector
    [Documentation]    Test ID: 10.3.1.2.9
    ...    Test title: GET Policies with "exclude_fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of existing policies with "exclude_fields" attribute selector.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get Policies with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Policies   
    
GET Policies with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 10.3.1.2.10
    ...    Test title: GET Policies with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of existing policies with "exclude_default" and "fields" attribute selector
    ...    Pre-conditions: 
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none 
    ...    Post-Conditions: none
    Get Policies with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Policies  
        
GET Policies as Paged Response
    [Documentation]    Test ID: 10.3.1.2.11
    ...    Test title: GET Policies as Paged Response
    ...    Test objective: The objective is to test that GET method retrieves the list of existing policies as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: NFV-MANO supports paged response.
    ...    Post-Conditions: none    
    GET Policies with Paging support
    Check HTTP Response Status Code Is  200
    Check HTTP Response Header Contains Link

PUT Policies - Method not implemented
     [Documentation]    Test ID: 10.3.1.2.12
    ...    Test title: PUT Policies - Method not implemented
    ...    Test objective: The objective is to test that PUT method cannot modify policies.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.3 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Policies
    Check HTTP Response Status Code Is    405

PATCH Policies - Method not implemented
    [Documentation]    Test ID: 10.3.1.2.13
    ...    Test title: PATCH Policies - Method not implemented
    ...    Test objective: The objective is to test that PATCH method cannot modify policies.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.4 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Policies
    Check HTTP Response Status Code Is    405

DELETE Policies - Method not implemented
    [Documentation]    Test ID: 10.3.1.2.14
    ...    Test title: DELETE Policies - Method not implemented
    ...    Test objective: The objective is to test that DELETE method cannot delete policies.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.5 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Policies are not deleted
    DELETE Policies
    Check HTTP Response Status Code Is    405
    Check Postcondition Policies Exist

POST Create a new Policy with permitted authorization scope
    [Documentation]    Test ID: 10.3.1.2.15
    ...    Test title: POST Create a new Policy with permitted authorization scope
    ...    Test objective: The objective is to test that POST method creates a policy with permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Policy is created.     
    POST Policies with permitted authorization scope
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    Policy
    Check HTTP Response Header Contains    Location

POST Create a new Policy with not permitted authorization scope
    [Documentation]    Test ID: 10.3.1.2.16
    ...    Test title: POST Create a new Policy with not permitted authorization scope
    ...    Test objective: The objective is to test that POST method to create a policy fails when a not permitted authorization scope is used.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.3.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none.     
    POST Policies with not permitted authorization scope
    Check HTTP Response Status Code Is    401