*** Settings ***
Resource   environment/variables.txt 
Resource   PolicyManagementKeywords.robot  

*** Test Cases ***
POST Particular Version of an Individual Policy - Method not implemented
    [Documentation]    Test ID: 10.3.1.5.1
    ...    Test title: POST Particular Version of an Individual Policy - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.6.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Particular Version of an Individual Policy
    Check HTTP Response Status Code Is    405

GET Information about a Particular Version of an Individual Policy - Successful
     [Documentation]    Test ID: 10.3.1.5.2
    ...    Test title: GET Information about a Particular Version of an Individual Policy - Successful
    ...    Test objective: The objective is to test that GET method fetches the content of a particular version of an individual policy.
    ...    Pre-conditions: Individual policy is available in the NFV-MANO. Policy contents are provided in the json/PolicyContent folder.
    ...    Reference: Clause 5.5.6.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The policy content type is either JSON, YAML or ZIP.
    ...    Post-Conditions: none
    GET Particular Version of an Individual Policy
    Check HTTP Response Status Code Is    200
    Check that the Content-Type Header Is Set
    
GET Information about a Particular Version of an Individual Policy - NOT FOUND
     [Documentation]    Test ID: 10.3.1.5.3
    ...    Test title: GET Information about a Particular Version of an Individual Policy - NOT FOUND
    ...    Test objective: The objective is to test that the information about a particular version of an individual policy fails when using an invalid resource identifier.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.6.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Particular Version of an Individual Policy with Invalid URI
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Particular Version of an individual policy - Successful
     [Documentation]    Test ID: 10.3.1.5.4
    ...    Test title: PUT Particular Version of an individual policy - Successful
    ...    Test objective: The objective is to test that the PUT method transfers the content of a particular version of an individual policy.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.6.3.3 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The policy content type is either JSON, YAML or ZIP.
    ...    Post-Conditions: none
    PUT Particular Version of an Individual Policy
    Check HTTP Response Status Code Is    201

PUT Particular Version of an individual policy - CONFLICT
     [Documentation]    Test ID: 10.3.1.5.5
    ...    Test title: PUT Particular Version of an individual policy - CONFLICT
    ...    Test objective: The objective is to test that the PUT method does not transfer the content of a particular version in case of a conflict.
    ...    Pre-conditions: The particular version has already been transferred to the API producer.
    ...    Reference: Clause 5.5.6.3.3 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The policy content type is either JSON, YAML or ZIP.
    ...    Post-Conditions: none
    PUT Particular Version of an Individual Policy CONFLICT
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails

PATCH Particular Version of an individual policy - Method not implemented 
     [Documentation]    Test ID: 10.3.1.5.6
    ...    Test title: PATCH Particular Version of an individual policy - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.6.3.4 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Particular Version of an Individual Policy
    Check HTTP Response Status Code Is    405

DELETE Particular Version of an individual policy - Successful 
     [Documentation]    Test ID: 10.3.1.5.7
    ...    Test title: DELETE Particular Version of an individual policy - Successful
    ...    Test objective: The objective is to test that the DELETE method deletes a particular version of an individual policy.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.6.3.5 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Particular Version of an Individual Policy
    Check HTTP Response Status Code Is    204

DELETE Particular Version of an individual policy - CONFLICT
     [Documentation]    Test ID: 10.3.1.5.8
    ...    Test title: DELETE Particular Version of an individual policy - CONFLICT
    ...    Test objective: The objective is to test that the DELETE method does not delete a particular version of an individual policy in case of a conflict.
    ...    Pre-conditions:  The requested version of the individual policy is the selected version.
    ...    Reference: Clause 5.5.6.3.5 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Particular Version of an Individual Policy
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Particular Version of an individual policy with permitted authorization scope
     [Documentation]    Test ID: 10.3.1.5.9
    ...    Test title: PUT Particular Version of an individual policy with permitted authorization scope
    ...    Test objective: The objective is to test that the PUT method transfers the content of a particular version of an individual policy when a permitted authorization scope is used.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.6.3.3 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The policy content type is either JSON, YAML or ZIP.
    ...    Post-Conditions: none
    PUT Particular Version of an Individual Policy with permitted authorization scope
    Check HTTP Response Status Code Is    201

PUT Particular Version of an individual policy with not permitted authorization scope
     [Documentation]    Test ID: 10.3.1.5.10
    ...    Test title: PUT Particular Version of an individual policy with not permitted authorization scope
    ...    Test objective: The objective is to test that the PUT method fails to transfer the content of a particular version of an individual policy when a not permitted authorization scope is used..
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.6.3.3 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The policy content type is either JSON, YAML or ZIP.
    ...    Post-Conditions: none
    PUT Particular Version of an Individual Policy with not permitted authorization scope
    Check HTTP Response Status Code Is    401
