*** Settings ***
Suite Setup       Create Sessions
Suite Teardown    Terminate All Processes    kill=true
Resource          environment/variables.txt
Library           MockServerLibrary
Library           Process
Library           OperatingSystem
Library           Collections

*** Test Cases ***
Policy Change Notification
    [Documentation]    Test ID: 10.3.1.8.1
    ...    Test title: Policy Change Notification
    ...    Test objective: The objective is to test the dispatch of Policy Change Notification when the policy is changed, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A subscription for policy change notification is available in the NFV-MANO.
    ...    Reference: Clause 5.5.9.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger a change in Policy (external action) 
    Check Policy Management Notification Http POST Request Body Json Schema Is    PolicyChangeNotification
    Check Policy Management Notification Http POST Request Body notificationType attribute Is    PolicyChangeNotification
    
Policy Conflict Notification
    [Documentation]    Test ID: 10.3.1.8.2
    ...    Test title: Policy Conflict Notification
    ...    Test objective: The objective is to test the dispatch of Policy Conflict Notification when a conflict in policy is detected, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A subscription for policy conflict notification is available in the NFV-MANO.
    ...    Reference: Clause 5.5.9.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger a conflict in Policy (external action) 
    Check Policy Management Notification Http POST Request Body Json Schema Is    PolicyConflictNotification
    Check Policy Management Notification Http POST Request Body notificationType attribute Is    PolicyConflictNotification
    
*** Keywords ***
Create Sessions
    Start Process  java  -jar  ${MOCK_SERVER_JAR}  -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
    
Trigger a change in Policy (external action) 
    #do nothing
    Log    do nothing
    
Trigger a conflict in Policy (external action) 
    #do nothing
    Log    do nothing

Configure Notification Forward
    [Arguments]    ${schema}    ${endpoint}    ${endpoint_fwd}    
    Log  Creating mock Http POST forward to handle ${schema}
    &{notification_tmp}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON_SCHEMA"    body=${schema}
    &{notification_fwd}=  Create Mock Http Forward	${endpoint_fwd}
    Create Mock Expectation With Http Forward  ${notification_tmp}  ${notification_fwd}

Configure Policy Management Notification Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary   ${json}    notificationType    ${type}
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}   
    &{notification_response}=  Create Mock Response    status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
    
Check Policy Management Notification Http POST Request Body Json Schema Is 
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}
    
Check Policy Management Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Policy Management Notification Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}
   