*** Settings ***
Resource   environment/variables.txt
Resource   PolicyManagementKeywords.robot  
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
Policy Change Notification
    [Documentation]    Test ID: 10.3.1.9.1
    ...    Test title: Policy Change Notification
    ...    Test objective: The objective is to test that Policy Change Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A subscription for policy change notification is available in the NFV-MANO.
    ...    Reference: Clause 5.5.9.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Policy Change Notification
    Check HTTP Response Status Code Is    204
    
Policy Conflict Notification
    [Documentation]    Test ID: 10.3.1.9.2
    ...    Test title: Policy Conflict Notification
    ...    Test objective: The objective is to test that Policy Conflict Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A subscription for policy conflict notification is available in the NFV-MANO.
    ...    Reference: Clause 5.5.9.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Policy Conflict Notification
    Check HTTP Response Status Code Is    204
    
Test the Notification Endpoint - Successful
    [Documentation]    Test ID: 10.3.1.9.3
    ...    Test title: Test the Notification Endpoint - Successful
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 5.5.9.3.2 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get reach the notification endpoint
    Check HTTP Response Status Code Is    204
    
Test the Notification Endpoint - UNREACHABLE
    [Documentation]    Test ID: 10.3.1.9.4
    ...    Test title: Test the Notification Endpoint - UNREACHABLE
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 5.5.7.3.1 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: The notification endpoint is unreachable by the API producer.
    ...    Post-Conditions: none 
    GET reach an unreachable notification endpoint
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails    
    
PUT Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 10.3.1.9.5
    ...    Test title: PUT Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PUT method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 5.5.9.3.3 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT notification endpoint
    Check HTTP Response Status Code Is    405
    
PATCH Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 10.3.1.9.6
    ...    Test title: PATCH Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PATCH method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 5.5.9.3.4 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH notification endpoint
    Check HTTP Response Status Code Is    405

DELETE Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 10.3.1.9.7
    ...    Test title: DELETE Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the DELETE method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 5.5.9.3.5 - ETSI GS NFV-SOL 012 [9] v4.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE notification endpoint
    Check HTTP Response Status Code Is    405