*** Settings ***
Resource    environment/variables.txt
Library     DependencyLibrary
Resource    PolicyManagementKeywords.robot

*** Test Cases ***
POST API Version - Method not implemented
    [Documentation]    Test ID: 10.3.1.1.1
    ...    Test title: POST API version - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.1 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none    
    POST API Version
	Check HTTP Response Status Code Is    405
    
GET API Version
    [Documentation]    Test ID: 10.3.1.1.2
    ...    Test title: GET API Version
    ...    Test objective: The objective is to test that GET method successfully returns ApiVersionInformation.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.2 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET API Version
	Check HTTP Response Status Code Is    200
	Check HTTP Response Body Json Schema Is    ApiVersionInformation

PUT API Version - Method not implemented
    [Documentation]    Test ID: 10.3.1.1.3
    ...    Test title: PUT API Version - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.3 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT API Version
	Check HTTP Response Status Code Is    405

PATCH API Version - Method not implemented
    [Documentation]    Test ID: 10.3.1.1.4
    ...    Test title: PATCH API Version - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.4 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH API Version
	Check HTTP Response Status Code Is    405
    
DELETE API Version - Method not implemented
    [Documentation]    Test ID: 10.3.1.1.5
    ...    Test title: DELETE API Version - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.5 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE API Version
	Check HTTP Response Status Code Is    405
	
POST API Version with apiMajorVersion - Method not implemented
    [Documentation]    Test ID: 10.3.1.1.6
    ...    Test title: POST API version with apiMajorVersion - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.1 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none    
    POST API Version
	Check HTTP Response Status Code Is    405
    
GET API Version with apiMajorVersion
    [Documentation]    Test ID: 10.3.1.1.7
    ...    Test title: GET API Version with apiMajorVersion
    ...    Test objective: The objective is to test that GET method successfully returns ApiVersionInformation.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.2 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET API Version
	Check HTTP Response Status Code Is    200
	Check HTTP Response Body Json Schema Is    ApiVersionInformation

PUT API Version with apiMajorVersion - Method not implemented
    [Documentation]    Test ID: 10.3.1.1.8
    ...    Test title: PUT API Version with apiMajorVersion - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.3 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT API Version
	Check HTTP Response Status Code Is    405

PATCH API Version with apiMajorVersion - Method not implemented
    [Documentation]    Test ID: 10.3.1.1.9
    ...    Test title: PATCH API Version with apiMajorVersion - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.4 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH API Version
	Check HTTP Response Status Code Is    405
    
DELETE API Version with apiMajorVersion - Method not implemented
    [Documentation]    Test ID: 10.3.1.1.10
    ...    Test title: DELETE API Version with apiMajorVersion - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.5 - ETSI GS NFV-SOL 013 [5] v4.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE API Version
	Check HTTP Response Status Code Is    405