# NFV API Tests

This folder includes the NFV API conformance test descriptions for NFV SOL011 APIs.

The reference spec version is v4.5.1: https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/011/04.05.01_60/gs_NFV-SOL011v040501p.pdf

## Applicable Tests
In addition to the SOL011 tests included in this folder for NS Instance Usage Notification API and NS Lifecycle Operation Granting API, the SOL011 tests make use of applicable SOL005 tests.
The following SOL011 interfaces reference the related SOL005 interfaces. 

### SOL011 NSD Management
The interface follows the provisions specified in the clause 5 of ETSI GS NFV-SOL 005 for the NSD management interface, except that the producer is NFVO-N and the consumer is NFVO-C.
The following SOL005 NSD Management conformance tests only are applicable to SOL011:


| Resource                  | Applicable Test IDs           |
|---------------------------|-------------------------------|
| NS Descriptors            | 5.3.1.1.1-10, 5.3.1.1.1-15-17 |
| Individual NS Descriptors | 5.3.1.2.1-2                   |


### SOL011 NS Lifecycle Management
The interface follows the provisions specified in the clause 6 of ETSI GS NFV-SOL 005 [3] for the NS lifecycle management interface, except that the producer is NFVO-N and the consumer is NFVO-C.
All of the SOL005 NS Lifecycle Management tests are applicable to SOL011, except for the following ones:

| Resource                  | Not Applicable Test IDs       |
|---------------------------|-------------------------------|
| Update NS task            | 5.3.2.5.1-6, 5.3.2.24.1       |

### SOL011 NS Performance Management
The interface follows the provisions specified in the clause 7 of ETSI GS NFV-SOL 005 for the performance management interface, except that the producer is NFVO-N and the consumer is NFVO-C.
All of the SOL005 NS Performance Management tests are applicable to SOL011.

### SOL011 NS Fault Management
The interface follows the provisions specified in the clause 8 of ETSI GS NFV-SOL 005 for the fault management interface, except that the producer is NFVO-N and the consumer is NFVO-C.
All of the SOL005 NS Fault Management tests are applicable to SOL011.

