*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
POST Individual Peer Entity - Method not implemented
    [Documentation]    Test ID: 8.3.1.9.1
    ...    Test title: POST Individual Peer Entity - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.14.3.1 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for Individual Peer Entity
    Check HTTP Response Status Code Is    405
    
GET Individual Peer Entity
    [Documentation]    Test ID: 8.3.1.9.2
    ...    Test title: GET Individual Peer Entity
    ...    Test objective: The objective is to retrieves information and configuration hold in the producer NFV-MANO functional entity with regards to a peer entity by reading an individual peer entity resource
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.14.3.2 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    Get Individual Peer Entity
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PeerEntity
    
GET Individual Peer Entity - Not Found
    [Documentation]    Test ID: 8.3.1.9.3
    ...    Test title: GET Individual Peer Entity - Not Found
    ...    Test objective: The objective is to test the retrieval of information and configuration hold in the producer NFV-MANO functional entity with regards to a peer entity by reading an individual peer entity resource fails when the resource is not present.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.14.3.2 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Peer Entity
    Check HTTP Response Status Code Is    404
    
PUT Individual Peer Entity - Method not implemented
    [Documentation]    Test ID: 8.3.1.9.4
    ...    Test title: PUT Individual Peer Entity - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.14.3.3 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for Individual Peer Entity
    Check HTTP Response Status Code Is    405
    
PATCH Individual Peer Entity
    [Documentation]    Test ID: 8.3.1.9.5
    ...    Test title: PATCH Individual Peer Entity
    ...    Test objective: This method modifies configuration and information of the producer NFV-MANO functional entity with regards to a peer functional entity by updating the corresponding "Individual peer entity" resource.
    ...    Pre-conditions: At least one Peer Entity resource is created
    ...    Reference: clause 5.5.14.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Peer Entity Resource is modified by the operation
    Send Patch request for Individual Peer Entity
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PeerEntityConfigModifications
    
PATCH Individual Peer Entity - Conflict
    [Documentation]    Test ID: 8.3.1.9.6
    ...    Test title: PATCH Individual Peer Entity - Conflict
    ...    Test objective: The objective is to test that the modification of configuration and information of the producer NFV-MANO functional entity with regards to a peer functional entity by updating the corresponding "Individual peer entity" resource failed due to a conflict with the state of the Individual Peer Entity resource and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one Peer Entity resource is created
    ...    Reference: clause 5.5.14.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Peer Entity Resource is not modified by the operation
    Send Patch request for Individual Peer Entity
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PATCH Individual Peer Entity - PreCondition Failed
    [Documentation]    Test ID: 8.3.1.9.7
    ...    Test title: PATCH Individual Peer Entity - PreCondition Failed
    ...    Test objective: The objective is to test that the modification of the Individual Peer Entity resource failed because precondition given in an HTTP request header is not fulfilled and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one Peer Entity resource is created
    ...    Reference: clause 5.5.14.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Peer Entity Resource is not modified by the operation
    Send Patch request for Individual Peer Entity
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
DELETE Individual Peer Entity - Method not implemented
    [Documentation]    Test ID: 8.3.1.9.8
    ...    Test title: DELETE Individual Peer Entity - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.14.3.5 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for Individual Peer Entity
    Check HTTP Response Status Code Is    405

PATCH Individual Peer Entity with permitted authorization scope
    [Documentation]    Test ID: 8.3.1.9.9
    ...    Test title: PATCH Individual Peer Entity with permitted authorization scope
    ...    Test objective: This method modifies configuration and information of the producer NFV-MANO functional entity with permitted authorization scope.
    ...    Pre-conditions: At least one Peer Entity resource is created
    ...    Reference: clause 5.5.14.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Peer Entity Resource is modified by the operation
    Send Patch request for Individual Peer Entity with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PeerEntityConfigModifications

PATCH Individual Peer Entity with not permitted authorization scope
    [Documentation]    Test ID: 8.3.1.9.10
    ...    Test title: PATCH Individual Peer Entity with not permitted authorization scope
    ...    Test objective: This method tests that modification of configuration and information of the producer NFV-MANO functional entity fails with not permitted authorization scope.
    ...    Pre-conditions: At least one Peer Entity resource is created
    ...    Reference: clause 5.5.14.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Peer Entity Resource is modified by the operation
    Send Patch request for Individual Peer Entity with not permitted authorization scope
    Check HTTP Response Status Code Is    401