*** Settings ***
Resource          NFVMANOPMKeywords.robot

*** Test Cases ***
POST Individual Threshold - Method not implemented
    [Documentation]    Test ID: 8.3.2.5.1
    ...    Test title: POST Individual Threshold - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new Performance Threshold
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.7.3.1 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for individual Performance Threshold
    Check HTTP Response Status Code Is    405
    
GET Individual Threshold
    [Documentation]    Test ID: 8.3.2.5.2
    ...    Test title: GET Individual Threshold
    ...    Test objective: The objective is to test the retrieval of an individual NFV-MANO performance threshold and perform a JSON schema and content validation of the collected threshold data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.2 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual Performance Threshold
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Threshold
    Check HTTP Response Body Threshold Identifier matches the requested Threshold

GET Individual Threshold with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.5.3
    ...    Test title: GET Individual Threshold with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual performance threshold fails when using an invalid resource identifier
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance jobs are set.
    ...    Reference: clause 6.5.7.3.2 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual Performance Threshold with invalid resource identifier
    Check HTTP Response Status Code Is    404

PUT Individual Threshold - Method not implemented
    [Documentation]    Test ID: 8.3.2.5.4
    ...    Test title: PUT Individual Threshold - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing Performance threshold
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.7.3.3 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for individual Performance Threshold
    Check HTTP Response Status Code Is    405

PATCH Individual Threshold
    [Documentation]    Test ID: 8.3.2.5.5
    ...    Test title: PATCH Individual Threshold
    ...    Test objective: The objective is to test that PATCH method modify an existing NFV_MANO performance threshold.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Threshold resource is modified.
    Send Patch request for individual Performance Threshold
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ThresholdModifications
    
DELETE Individual Threshold
    [Documentation]    Test ID: 8.3.2.5.6
    ...    Test title: DELETE Individual Threshold
    ...    Test objective: The objective is to test the deletion of an individual performance threshold
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.5 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Performance Threshold is not available anymore in the NFV-MANO    
    Send Delete request for individual Performance Threshold
    Check HTTP Response Status Code Is    204
    Check Postcondition Performance Threshold is Deleted

DELETE Individual Threshold with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.5.7
    ...    Test title: DELETE Individual Threshold with invalid resource identifier
    ...    Test objective: The objective is to test the deletion of an individual performance threshold
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.5 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none   
    Send Delete request for individual Performance Threshold with invalid resource identifier
    Check HTTP Response Status Code Is    404

PATCH Individual Threshold - Precondition failed
    [Documentation]    Test ID: 8.3.2.5.8
    ...    Test title: PATCH Individual Threshold - Precondition failed
    ...    Test objective: The objective is to test that the PATCH method cannot modify an individual NFV-MANO threshold where the precondition was not met.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Threshold resource is not modified.
    Send Patch request for individual Performance Threshold - Etag mismatch
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is    ProblemDetails

PATCH Individual Threshold - Unprocessable content
    [Documentation]    Test ID: 8.3.2.5.9
    ...    Test title: PATCH Individual Threshold - Unprocessable content
    ...    Test objective: The objective is to test that PATCH method cannot modify an exsisting individual threshold resource when a request contains syntactically correct data but the data cannot be processed.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Threshold resource is not modified.
    Send Patch request for individual Performance Threshold with unprocessable content
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails

PATCH Individual Threshold with permitted authorization scope
    [Documentation]    Test ID: 8.3.2.5.10
    ...    Test title: PATCH Individual Threshold with permitted authorization scope
    ...    Test objective: The objective is to test that PATCH method modify an existing NFV_MANO performance threshold with permitted authorization scope.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Threshold resource is modified.
    Send Patch request for individual Performance Threshold with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ThresholdModifications

PATCH Individual Threshold with not permitted authorization scope
    [Documentation]    Test ID: 8.3.2.5.11
    ...    Test title: PATCH Individual Threshold with not permitted authorization scope
    ...    Test objective: The objective is to test that PATCH method fails with not permitted authorization scope.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Threshold resource is modified.
    Send Patch request for individual Performance Threshold with not permitted authorization scope
    Check HTTP Response Status Code Is    401
