*** Settings ***
Resource          NFVMANOPMKeywords.robot

*** Test Cases ***
POST Individual NFV-MANO Performance Job - Method not implemented
    [Documentation]    Test ID: 8.3.2.2.1
    ...    Test title: POST Individual NFV-MANO Performance Job - method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new NFV-MANO Performance Monitoring Job
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.4.3.1 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    405
    
GET individual NFV-MANO Performance Job
    [Documentation]    Test ID: 8.3.2.2.2
    ...    Test title: Get individual NFV-MANO Performance Job
    ...    Test objective: The objective is to test the retrieval of an individual performance monitoring job and perform a JSON schema validation of the collected job data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated.
    ...    Reference: clause 6.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PmJob
    Check HTTP Response Body Pm Job Identifier matches the requested Pm Job

GET individual NFV-MANO Performance Job with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.2.3
    ...    Test title: Get individual NFV-MANO Performance Job with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual performance monitoring job fails when using an invalid resource identifier, and perform the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual NFV-MANO Performance Job with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PUT Individual NFV-MANO Performance Job - Method not implemented
    [Documentation]    Test ID: 8.3.2.2.4
    ...    Test title: PUT Individual NFV-MANO Performance Job - method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing NFV-MANO Performance Monitoring Job
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    405

PATCH Individual NFV-MANO Performance Job
    [Documentation]    Test ID: 8.3.2.2.5
    ...    Test title: PATCH Individual NFV-MANO Performance Job
    ...    Test objective: The objective is to test that PATCH method modify an existing individual NFV-MANO Performance Monitoring Job
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: PM Job resource is modified.
    Send Patch request for individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is     PmJobModifications

DELETE Individual NFV-MANO Performance Job
    [Documentation]    Test ID: 8.3.2.2.6
    ...    Test title: Delete Individual NFV-MANO Performance Job
    ...    Test objective: The objective is to test the deletion of an individual performance monitoring job
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.5 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The NFV-MANO Performance Job is no more available.   
    Send Delete request for individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    204
    Check Postcondition NFV-MANO Pm Job is Deleted

DELETE Individual NFV-MANO Performance Job with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.2.7
    ...    Test title: Delete individual NFV-MANO Performance Job with invalid resource identifier
    ...    Test objective: The objective is to test that the deletion of an individual NFV-MANO performance monitoring job fails when using an invalid resource identifier
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.5 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for individual NFV-MANO Performance Job with invalid resource identifier
    Check HTTP Response Status Code Is    404

PATCH Individual NFV-MANO Performance Job - Precondition failed
    [Documentation]    Test ID: 8.3.2.2.8
    ...    Test title: PATCH Individual NFV-MANO Performance Job - Precondition failed
    ...    Test objective: The objective is to test that the PATCH method cannot modify an individual NFV-MANO Performance job where the precondition was not met.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: PM Job resource is not modified.
    Send Patch request for individual NFV-MANO Performance Job - Etag mismatch
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is     ProblemDetails

PATCH Individual NFV-MANO Performance Job - Unprocessable content
    [Documentation]    Test ID: 8.3.2.2.9
    ...    Test title: PATCH Individual NFV-MANO Performance Job - Unprocessable content
    ...    Test objective: The objective is to test that PATCH method cannot modify an exsisting individual PM job resource when a request contains syntactically correct data but the data cannot be processed.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: PM Job resource is not modified.
    Send Patch request for individual NFV_MANO Performance Job with unprocessable content
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is     ProblemDetails

PATCH Individual NFV-MANO Performance Job with permitted authorization scope
    [Documentation]    Test ID: 8.3.2.2.10
    ...    Test title: PATCH Individual NFV-MANO Performance Job with permitted authorization scope
    ...    Test objective: The objective is to test that PATCH method with permitted authorization scope modify an existing individual NFV-MANO Performance Monitoring Job
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: PM Job resource is modified.
    Send Patch request for individual NFV-MANO Performance Job with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is     PmJobModifications

PATCH Individual NFV-MANO Performance Job with not permitted authorization scope
    [Documentation]    Test ID: 8.3.2.2.11
    ...    Test title: PATCH Individual NFV-MANO Performance Job with not permitted authorization scope
    ...    Test objective: The objective is to test that PATCH method with not permitted authorization scope fails
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance jobs are set in the NFV-MANO.
    ...    Reference: clause 6.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: PM Job resource is modified.
    Send Patch request for individual NFV-MANO Performance Job with not permitted authorization scope
    Check HTTP Response Status Code Is    401
