*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST Extract VNF Snapshot Package Content Task
    [Documentation]    Test ID: 5.3.7.7.1
    ...    Test title: POST Extract VNF Snapshot Package Content Task
    ...    Test objective: The objective is to test that POST method provides the information for the NFVO to start extracting the content of a VNF snapshot package.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Extract VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    202 

POST Extract VNF Snapshot Package Content Task - Conflict State
    [Documentation]    Test ID: 5.3.7.7.2
    ...    Test title: POST Extract VNF Snapshot Package Content Task - Conflict
    ...    Test objective: The objective is to test that a correct error code is returned when the POST method tries to intiate extraction of VNF Snapshot Package and the state of the VNF snapshot package resource is other than "AVAILABLE".
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The state of the VNF snapshot package resource is other than "AVAILABLE".
    ...    Post-Conditions: none
    POST Extract VNF Snapshot Package Content Task - Conflict State
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails

POST Extract VNF Snapshot Package Content Task - Invalid VnfInstanceId
    [Documentation]    Test ID: 5.3.7.7.3
    ...    Test title: POST Extract VNF Snapshot Package Content Task - Conflict
    ...    Test objective: The objective is to test that a correct error code is returned when the POST method tries to intiate extraction of VNF Snapshot Package using an invalid VnfInstanceId in the request body.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The state of the VNF snapshot package resource is other than "CREATED".
    ...    Post-Conditions: none
    POST Extract VNF Snapshot Package Content Task - Invalid vnfInstanceId
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET Extract VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.7.4
    ...    Test title: GET Extract VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that GET method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Extract VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

PUT Extract VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.7.5
    ...    Test title: PUT Extract VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Extract VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405
    
PATCH Extract VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.7.6
    ...    Test title: PATCH Extract VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Extract VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

DELETE Extract VNF Snapshot Package Content Task - Method Not implemented 
    [Documentation]    Test ID: 5.3.7.7.7
    ...    Test title: DELETE Extract VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Extract VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

POST Extract VNF Snapshot Package Content Task with permitted authorization scope
    [Documentation]    Test ID: 5.3.7.7.8
    ...    Test title: POST Extract VNF Snapshot Package Content Task with permitted authorization scope
    ...    Test objective: The objective is to test that POST method provides the information for the NFVO to start extracting the content of a VNF snapshot package with permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Extract VNF Snapshot Package Content Task with permitted authorization scope
    Check HTTP Response Status Code Is    202 

POST Extract VNF Snapshot Package Content Task with not permitted authorization scope
    [Documentation]    Test ID: 5.3.7.7.9
    ...    Test title: POST Extract VNF Snapshot Package Content Task with not permitted authorization scope
    ...    Test objective: The objective is to test that POST method fails to provide the information for the NFVO to start extracting the content of a VNF snapshot package when using not permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.7.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Extract VNF Snapshot Package Content Task with not permitted authorization scope
    Check HTTP Response Status Code Is    401