*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST Cancel VNF Snapshot Package Content Task
    [Documentation]    Test ID: 5.3.7.8.1
    ...    Test title: POST Cancel VNF Snapshot Package Content Task
    ...    Test objective: The objective is to test that  POST method provides the information for the NFVO to cancel the ongoing operation related to the content of a VNF snapshot package.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Cancel VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    202 

POST Cancel VNF Snapshot Package Content Task - Conflict
    [Documentation]    Test ID: 5.3.7.8.2
    ...    Test title: POST Cancel VNF Snapshot Package Content Task - Conflict
    ...    Test objective: The objective is to test that a correct error code is returned when the POST method tries to cancel a VNF Snapshot Package task and the state of the VNF snapshot package resource is other than "UPLOADING", "BUILDING", "PROCESSING" or "EXTRACTING".
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The state of the VNF snapshot package resource is other than "UPLOADING", "BUILDING", "PROCESSING" or "EXTRACTING".
    ...    Post-Conditions: none
    POST Cancel VNF Snapshot Package Content Task - Conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET Cancel VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.8.3
    ...    Test title: GET Cancel VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that GET method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Cancel VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

PUT Cancel VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.8.4
    ...    Test title: PUT Cancel VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Cancel VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405
    
PATCH Cancel VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.8.5
    ...    Test title: PATCH Cancel VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Cancel VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

DELETE Cancel VNF Snapshot Package Content Task - Method Not implemented 
    [Documentation]    Test ID: 5.3.7.8.6
    ...    Test title: DELETE Cancel VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Cancel VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

POST Cancel VNF Snapshot Package Content Task with permitted authorization scope
    [Documentation]    Test ID: 5.3.7.8.1
    ...    Test title: POST Cancel VNF Snapshot Package Content Task with permitted authorization scope
    ...    Test objective: The objective is to test that  POST method provides the information for the NFVO to cancel the ongoing operation related to the content of a VNF snapshot package with permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Cancel VNF Snapshot Package Content Task with permitted authorization scope
    Check HTTP Response Status Code Is    202 

POST Cancel VNF Snapshot Package Content Task with not permitted authorization scope
    [Documentation]    Test ID: 5.3.7.8.1
    ...    Test title: POST Cancel VNF Snapshot Package Content Task with not permitted authorization scope
    ...    Test objective: The objective is to test that  POST method fails to  provide the information for the NFVO to cancel the ongoing operation related to the content of a VNF snapshot package when using not permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Cancel VNF Snapshot Package Content Task with not permitted authorization scope
    Check HTTP Response Status Code Is    401