*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST Build VNF Snapshot Package Content Task
    [Documentation]    Test ID: 5.3.7.6.1
    ...    Test title: POST Build VNF Snapshot Package Content Task
    ...    Test objective: The objective is to test that POST method provides the information for the NFVO to start building the content of a VNF snapshot package.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Build VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    202 

POST Build VNF Snapshot Package Content Task - Conflict
    [Documentation]    Test ID: 5.3.7.6.2
    ...    Test title: POST Build VNF Snapshot Package Content Task - Conflict
    ...    Test objective: The objective is to test that a correct error code is returned when the POST method tries to intiate building of VNF Snapshot Package and the state of the VNF snapshot package resource is other than "CREATED".
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The state of the VNF snapshot package resource is other than "CREATED".
    ...    Post-Conditions: none
    POST Build VNF Snapshot Package Content Task - Conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET Build VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.6.3
    ...    Test title: GET Build VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that GET method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.6.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Build VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

PUT Build VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.6.4
    ...    Test title: PUT Build VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.6.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Build VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405
    
PATCH Build VNF Snapshot Package Content Task - Method Not implemented
    [Documentation]    Test ID: 5.3.7.6.5
    ...    Test title: PATCH Build VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.6.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Build VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

DELETE Build VNF Snapshot Package Content Task - Method Not implemented 
    [Documentation]    Test ID: 5.3.7.6.6
    ...    Test title: DELETE Build VNF Snapshot Package Content Task - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.6.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Build VNF Snapshot Package Content Task
    Check HTTP Response Status Code Is    405

POST Build VNF Snapshot Package Content Task with permitted authorization scope
    [Documentation]    Test ID: 5.3.7.6.7
    ...    Test title: POST Build VNF Snapshot Package Content Task with permitted authorization scope
    ...    Test objective: The objective is to test that POST method provides the information for the NFVO to start building the content of a VNF snapshot package with permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Build VNF Snapshot Package Content Task with permitted authorization scope
    Check HTTP Response Status Code Is    202

POST Build VNF Snapshot Package Content Task with not permitted authorization scope
    [Documentation]    Test ID: 5.3.7.6.8
    ...    Test title: POST Build VNF Snapshot Package Content Task with not permitted authorization scope
    ...    Test objective: The objective is to test that POST method fails to provide the information for the NFVO to start building the content of a VNF snapshot package when using a not permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Build VNF Snapshot Package Content Task with not permitted authorization scope
    Check HTTP Response Status Code Is    401