*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          VNFPackageManagementKeywords.robot    
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false

*** Test Cases ***
Get Manifest in Individual VNF Package
    [Documentation]    Test ID: 5.3.5.12.1
    ...    Test title: Get Manifest in Individual VNF Package
    ...    Test objective: The objective is to test that content of manifest within a NVF Package is read successfully.
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package in plainFormat
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain
    
Get Manifest in Individual VNF Package with security information
    [Documentation]    Test ID: 5.3.5.12.2
    ...    Test title: Get Manifest in Individual VNF Package with security information
    ...    Test objective: The objective is to test the retrieval of the Manifest in individual VNF package shall include in the ZIP archive the security information when requested with "include_signature" parameter, and perform a validation that returned content is in zip format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package with security information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
Get Manifest in Individual VNF Package - Not Acceptable
    [Documentation]    Test ID: 5.3.5.12.3
    ...    Test title: Get Manifest in Individual VNF Package - Not Acceptable
    ...    Test objective: The objective is to test that the "Accept" header is not compatible with Content type "application/zip" but "incude_signature" is provided.\
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package with unacceptable request
    Check HTTP Response Status Code Is    406
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
Get Manifest in Individual VNF Package - Conflict
    [Documentation]    Test ID: 5.3.5.12.4
    ...    Test title: Get Manifest in Individual VNF Package - Conflict
    ...    Test objective: The objective is to test that the operation cannot be executed currently, due to a conflict with the state of the resource.
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package in plainFormat
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
POST Manifest in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 5.3.5.12.5
    ...    Test title: POST Manifest in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create new Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.4b.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for Manifest in individual VNF Package
    Check HTTP Response Status Code Is    405

PUT Manifest in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 5.3.5.12.6
    ...    Test title: PUT Manifest in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify a Manifest
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for Manifest in individual VNF Package
    Check HTTP Response Status Code Is    405

PATCH Manifest in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 5.3.5.12.7
    ...    Test title: PATCH Manifest in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update a Manifest
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for Manifest in individual VNF Package
    Check HTTP Response Status Code Is    405

DELETE Manifest in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 5.3.5.12.8
    ...    Test title: DELETE Manifest in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that DELETE  method is not allowed to delete a Manifest
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for Manifest in individual VNF Package
    Check HTTP Response Status Code Is    405

Get Manifest in Individual VNF Package with permitted authorization scope
    [Documentation]    Test ID: 5.3.5.12.9
    ...    Test title: Get Manifest in Individual VNF Package with permitted authorization scope
    ...    Test objective: The objective is to test that content of manifest within a NVF Package is read successfully with permitted authorization scope.
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package in plainFormat with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain

Get Manifest in Individual VNF Package with not permitted authorization scope
    [Documentation]    Test ID: 5.3.5.12.10
    ...    Test title: Get Manifest in Individual VNF Package with not permitted authorization scope
    ...    Test objective: The objective is to test that content of manifest within a NVF Package fails when using not permitted authorization scope.
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package in plainFormat with not permitted authorization scope
    Check HTTP Response Status Code Is    401