*** Settings ***
Resource    NSLCMOperationKeywords.robot 

*** Test Cases ***
POST Individual VNF Snapshot - Method not implemented
    [Documentation]    Test ID: 5.3.2.28.1
    ...    Test title: POST Individual VNF Snapshot - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST individual VNF Snapshot
    Check HTTP Response Status Code Is    405
    
GET Information about an individual VNF Snapshot - SUCCESSFUL
    [Documentation]    Test ID: 5.3.2.28.2
    ...    Test title: GET Information about an individual VNF Snapshot - SUCCESSFUL
    ...    Test objective: The objective is to GET information about an individual VNF Snapshot
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual VNF Snapshot
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotInfo
        
GET Information about an individual VNF Snapshot - NOT FOUND
     [Documentation]    Test ID: 5.3.2.28.3
    ...    Test title: GET Information about an individual VNF Snapshot - NOT FOUND
    ...    Test objective: The objective is to test that the retrieval of individual VNF Snapshot fails when using an invalid resource identifier.
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VNF Snapshot with Invalid URI
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Individual VNF Snapshot - Method not implemented 
     [Documentation]    Test ID: 5.3.2.28.4
    ...    Test title: PUT Individual VNF Snapshot - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT individual VNF Snapshot
    Check HTTP Response Status Code Is    405

PATCH Individual VNF Snapshot - Method not implemented 
     [Documentation]    Test ID: 5.3.2.28.5
    ...    Test title: PATCH Individual VNF Snapshot - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot not modified
    PATCH individual VNF Snapshot
    Check HTTP Response Status Code Is    405

DELETE Individual VNF Snapshot
    [Documentation]    Test ID: 5.3.2.28.6
    ...    Test title: DELETE Individual VNF Snapshot
    ...    Test objective: The objective is to delete a VNF Snapshot
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot resource is deleted.
    DELETE individual VNF Snapshot
    Check HTTP Response Status Code Is    204
    Check Postcondition VNF Snapshot Resource Is Deleted

DELETE Individual VNF Snapshot - Conflict
     [Documentation]    Test ID: 5.3.2.28.7
    ...    Test title: DELETE Individual VNF Snapshot Conflict
    ...    Test objective: The objective is to verify that The operation cannot be executed currently, due to a conflict with the state of the VNF Snapshot resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: VNF snapshot is in use by some operation such as reverting a VNF instance to a VNF snapshot or creating a VNF snapshot package.
    ...    Post-Conditions: VNF Snapshot resource is not deleted.
    DELETE individual VNF Snapshot - CONFLICT
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails
    Check Postcondition VNF Snapshot Resource Existence

GET Information about an individual VNF Snapshot with permitted authorization scope
    [Documentation]    Test ID: 5.3.2.28.8
    ...    Test title: GET Information about an individual VNF Snapshot with permitted authorization scope
    ...    Test objective: The objective is to GET information about an individual VNF Snapshot with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual VNF Snapshot with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotInfo

GET Information about an individual VNF Snapshot with not permitted authorization scope
    [Documentation]    Test ID: 5.3.2.28.9
    ...    Test title: GET Information about an individual VNF Snapshot with permitted authorization scope
    ...    Test objective: The objective is to test that GET information about an individual VNF Snapshot fails when using not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.20.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual VNF Snapshot with not permitted authorization scope
    Check HTTP Response Status Code Is    401