*** Settings ***
Resource    environment/variables.txt 
Resource   NSLCMOperationKeywords.robot   
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
Post Individual NS LCM occurrences - Method not implemented
    [Documentation]    Test ID: 5.3.2.9.1
    ...    Test title: Post Individual NS LCM occurrences - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
	POST Individual NS LCM OP Occurrence
	Check HTTP Response Status Code Is    405

Get status information about Individual NS LCM occurrences   
    [Documentation]    Test ID: 5.3.2.9.2
    ...    Test title: Get status information about Individual NS LCM occurrences
    ...    Test objective: The objective is to test that GET method returns the LCM occurrence of the NS
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.10.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
	GET Individual NS LCM OP Occurrence
	Check HTTP Response Status Code Is    200
	Check HTTP Response Body Json Schema Is    NsLcmOpOcc
	Check NsLcmOpOcc content against NS Descriptor
	
PUT status information about Individual NS LCM occurrences - Method not implemented
     [Documentation]    Test ID: 5.3.2.9.3
    ...    Test title: PUT status information about Individual NS LCM occurrences - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.10.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Individual NS LCM OP Occurrence
    Check HTTP Response Status Code Is    405

PATCH status information about Individual NS LCM occurrences
     [Documentation]    Test ID: 5.3.2.9.4
    ...    Test title: PATCH status information about Individual NS LCM occurrences
    ...    Test objective: The objective is to test that PATCH method modify an existing Individual NS LCM occurrence
    ...    Pre-conditions: An Individual NS LCM occurrence represents a scheduled operation not yet started 
    ...    Reference: Clause 6.4.10.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual NS LCM OP Occurrence
    Check HTTP Response Status Code Is    204
    
PATCH status information about Individual NS LCM occurrences - scheduled operation already started
     [Documentation]    Test ID: 5.3.2.9.4b
    ...    Test title: PATCH status information about Individual NS LCM occurrences
    ...    Test objective: The objective is to test that PATCH method modify an existing Individual NS LCM occurrence
    ...    Pre-conditions: An Individual NS LCM occurrence represents a scheduled operation already started 
    ...    Reference: Clause 6.4.10.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual NS LCM OP Occurrence of Already Started Scheduled Operation 
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is     ProblemDetails

PATCH status information about Individual NS LCM occurrences - Precondition failed
     [Documentation]    Test ID: 5.3.2.9.4c
    ...    Test title: PATCH status information about Individual NS LCM occurrences - Precondition failed
    ...    Test objective: The objective is to test that PATCH method that modifies an existing Individual NS LCM occurrence fails if the resource was modified by another entity
    ...    Pre-conditions: An Individual NS LCM occurrence represents a scheduled operation not yet started 
    ...    Reference: Clause 6.4.10.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The resource was modified by another entity
    ...    Post-Conditions: none
    PATCH Individual NS LCM OP Occurrence - ETag mismatch
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is     ProblemDetails

PATCH status information about Individual NS LCM occurrences - Precondition failed HTTP Conditional Request Not Supported
     [Documentation]    Test ID: 5.3.2.9.4d
    ...    Test title: PATCH status information about Individual NS LCM occurrences - Precondition failed HTTP Conditional Request Not Supported
    ...    Test objective: The objective is to test that PATCH method that modifies an existing Individual NS LCM occurrence fails if the API Producer does not support "Last-Modified" and "ETag" HTTP Headers
    ...    Pre-conditions: An Individual NS LCM occurrence represents a scheduled operation not yet started 
    ...    Reference: Clause 6.4.10.3.4, 4.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: API Producer does not support "Last-Modified" and "ETag" HTTP Headers
    ...    Post-Conditions: none
    PATCH Individual NS LCM OP Occurrence - HTTP Conditional Request not supported
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is     ProblemDetails

DELETE status information about Individual NS LCM occurrences - Method not implemented
         [Documentation]    Test ID: 5.3.2.9.5
    ...    Test title: DELETE status information about Individual NS LCM occurrences - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.10.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Individual NS LCM OP Occurrence
    Check HTTP Response Status Code Is    405

PATCH status information about Individual NS LCM occurrences with permitted authorization scope
     [Documentation]    Test ID: 5.3.2.9.6
    ...    Test title: PATCH status information about Individual NS LCM occurrences with permitted authorization scope
    ...    Test objective: The objective is to test that PATCH method modify an existing Individual NS LCM occurrence with permitted authorization scope
    ...    Pre-conditions: An Individual NS LCM occurrence represents a scheduled operation not yet started 
    ...    Reference: Clause 6.4.10.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual NS LCM OP Occurrence with permitted authorization scope
    Check HTTP Response Status Code Is    204

PATCH status information about Individual NS LCM occurrences with not permitted authorization scope
     [Documentation]    Test ID: 5.3.2.9.4
    ...    Test title: PATCH status information about Individual NS LCM occurrences with not permitted authorization scope
    ...    Test objective: The objective is to test that PATCH method modify an existing Individual NS LCM occurrence fails when using not permitted authorization scope
    ...    Pre-conditions: An Individual NS LCM occurrence represents a scheduled operation not yet started 
    ...    Reference: Clause 6.4.10.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual NS LCM OP Occurrence with not permitted authorization scope
    Check HTTP Response Status Code Is    401